/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.sources.v1;

import io.fabric8.knative.sources.v1.ContainerSource;
import io.fabric8.knative.sources.v1.ContainerSourceBuilder;
import io.fabric8.knative.sources.v1.ContainerSourceFluentImpl;
import io.fabric8.knative.sources.v1.ContainerSourceList;
import io.fabric8.knative.sources.v1.ContainerSourceListFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ContainerSourceListFluentImpl<A extends ContainerSourceListFluent<A>>
extends BaseFluent<A>
implements ContainerSourceListFluent<A> {
    private String apiVersion;
    private ArrayList<ContainerSourceBuilder> items = new ArrayList();
    private String kind;
    private ListMeta metadata;

    public ContainerSourceListFluentImpl() {
    }

    public ContainerSourceListFluentImpl(ContainerSourceList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(Integer index, ContainerSource item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ContainerSourceBuilder builder = new ContainerSourceBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, ContainerSource item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ContainerSourceBuilder builder = new ContainerSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ContainerSource ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ContainerSource item : items) {
            ContainerSourceBuilder builder = new ContainerSourceBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ContainerSource> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ContainerSource item : items) {
            ContainerSourceBuilder builder = new ContainerSourceBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ContainerSource ... items) {
        for (ContainerSource item : items) {
            ContainerSourceBuilder builder = new ContainerSourceBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ContainerSource> items) {
        for (ContainerSource item : items) {
            ContainerSourceBuilder builder = new ContainerSourceBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ContainerSourceBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ContainerSourceBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ContainerSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerSource> getItems() {
        return this.items != null ? ContainerSourceListFluentImpl.build(this.items) : null;
    }

    @Override
    public List<ContainerSource> buildItems() {
        return this.items != null ? ContainerSourceListFluentImpl.build(this.items) : null;
    }

    @Override
    public ContainerSource buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public ContainerSource buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ContainerSource buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ContainerSource buildMatchingItem(Predicate<ContainerSourceBuilder> predicate) {
        for (ContainerSourceBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ContainerSourceBuilder> predicate) {
        for (ContainerSourceBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ContainerSource> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList();
            for (ContainerSource item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(ContainerSource ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ContainerSource item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ContainerSourceListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ContainerSourceListFluent.ItemsNested<A> addNewItemLike(ContainerSource item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ContainerSourceListFluent.ItemsNested<A> setNewItemLike(Integer index, ContainerSource item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ContainerSourceListFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ContainerSourceListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ContainerSourceListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ContainerSourceListFluent.ItemsNested<A> editMatchingItem(Predicate<ContainerSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerSourceListFluentImpl that = (ContainerSourceListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    class ItemsNestedImpl<N>
    extends ContainerSourceFluentImpl<ContainerSourceListFluent.ItemsNested<N>>
    implements ContainerSourceListFluent.ItemsNested<N>,
    Nested<N> {
        ContainerSourceBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, ContainerSource item) {
            this.index = index;
            this.builder = new ContainerSourceBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ContainerSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerSourceListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

