package io.fabric8.knative.serving.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DomainMappingSpecBuilder extends DomainMappingSpecFluentImpl<DomainMappingSpecBuilder> implements VisitableBuilder<DomainMappingSpec,DomainMappingSpecBuilder>{
  public DomainMappingSpecBuilder() {
    this(false);
  }
  public DomainMappingSpecBuilder(Boolean validationEnabled) {
    this(new DomainMappingSpec(), validationEnabled);
  }
  public DomainMappingSpecBuilder(DomainMappingSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DomainMappingSpecBuilder(DomainMappingSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DomainMappingSpec(), validationEnabled);
  }
  public DomainMappingSpecBuilder(DomainMappingSpecFluent<?> fluent,DomainMappingSpec instance) {
    this(fluent, instance, false);
  }
  public DomainMappingSpecBuilder(DomainMappingSpecFluent<?> fluent,DomainMappingSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRef(instance.getRef()); 
    fluent.withTls(instance.getTls()); 
    this.validationEnabled = validationEnabled; 
  }
  public DomainMappingSpecBuilder(DomainMappingSpec instance) {
    this(instance,false);
  }
  public DomainMappingSpecBuilder(DomainMappingSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRef(instance.getRef()); 
    this.withTls(instance.getTls()); 
    this.validationEnabled = validationEnabled; 
  }
  DomainMappingSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DomainMappingSpec build() {
    DomainMappingSpec buildable = new DomainMappingSpec(fluent.getRef(),fluent.getTls());
    return buildable;
  }
  
}