package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InMemoryChannelListBuilder extends InMemoryChannelListFluentImpl<InMemoryChannelListBuilder> implements VisitableBuilder<InMemoryChannelList,InMemoryChannelListBuilder>{
  public InMemoryChannelListBuilder() {
    this(false);
  }
  public InMemoryChannelListBuilder(Boolean validationEnabled) {
    this(new InMemoryChannelList(), validationEnabled);
  }
  public InMemoryChannelListBuilder(InMemoryChannelListFluent<?> fluent) {
    this(fluent, false);
  }
  public InMemoryChannelListBuilder(InMemoryChannelListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InMemoryChannelList(), validationEnabled);
  }
  public InMemoryChannelListBuilder(InMemoryChannelListFluent<?> fluent,InMemoryChannelList instance) {
    this(fluent, instance, false);
  }
  public InMemoryChannelListBuilder(InMemoryChannelListFluent<?> fluent,InMemoryChannelList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public InMemoryChannelListBuilder(InMemoryChannelList instance) {
    this(instance,false);
  }
  public InMemoryChannelListBuilder(InMemoryChannelList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  InMemoryChannelListFluent<?> fluent;
  Boolean validationEnabled;
  public InMemoryChannelList build() {
    InMemoryChannelList buildable = new InMemoryChannelList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}