package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DestinationBuilder extends DestinationFluentImpl<DestinationBuilder> implements VisitableBuilder<Destination,DestinationBuilder>{
  public DestinationBuilder() {
    this(false);
  }
  public DestinationBuilder(Boolean validationEnabled) {
    this(new Destination(), validationEnabled);
  }
  public DestinationBuilder(DestinationFluent<?> fluent) {
    this(fluent, false);
  }
  public DestinationBuilder(DestinationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Destination(), validationEnabled);
  }
  public DestinationBuilder(DestinationFluent<?> fluent,Destination instance) {
    this(fluent, instance, false);
  }
  public DestinationBuilder(DestinationFluent<?> fluent,Destination instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRef(instance.getRef()); 
    fluent.withUri(instance.getUri()); 
    this.validationEnabled = validationEnabled; 
  }
  public DestinationBuilder(Destination instance) {
    this(instance,false);
  }
  public DestinationBuilder(Destination instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRef(instance.getRef()); 
    this.withUri(instance.getUri()); 
    this.validationEnabled = validationEnabled; 
  }
  DestinationFluent<?> fluent;
  Boolean validationEnabled;
  public Destination build() {
    Destination buildable = new Destination(fluent.getRef(),fluent.getUri());
    return buildable;
  }
  
}