package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import java.lang.Integer;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SequenceStatusFluentImpl<A extends SequenceStatusFluent<A>> extends BaseFluent<A> implements SequenceStatusFluent<A>{
  public SequenceStatusFluentImpl() {
  }
  public SequenceStatusFluentImpl(SequenceStatus instance) {
    this.withAddress(instance.getAddress()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withChannelStatuses(instance.getChannelStatuses()); 
    this.withConditions(instance.getConditions()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withSubscriptionStatuses(instance.getSubscriptionStatuses()); 
  }
  private AddressableBuilder address;
  private Map<String,String> annotations;
  private ArrayList<SequenceChannelStatusBuilder> channelStatuses = new ArrayList<SequenceChannelStatusBuilder>();
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private Long observedGeneration;
  private ArrayList<SequenceSubscriptionStatusBuilder> subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>();
  
  /**
   * This method has been deprecated, please use method buildAddress instead.
   * @return The buildable object.
   */
  @Deprecated
  public Addressable getAddress() {
    return this.address!=null ?this.address.build():null;
  }
  public Addressable buildAddress() {
    return this.address!=null ?this.address.build():null;
  }
  public A withAddress(Addressable address) {
    _visitables.get("address").remove(this.address);
    if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} else { this.address = null; _visitables.get("address").remove(this.address); } return (A) this;
  }
  public Boolean hasAddress() {
    return this.address != null;
  }
  public A withNewAddress(String url) {
    return (A)withAddress(new Addressable(url));
  }
  public SequenceStatusFluent.AddressNested<A> withNewAddress() {
    return new SequenceStatusFluentImpl.AddressNestedImpl();
  }
  public SequenceStatusFluent.AddressNested<A> withNewAddressLike(Addressable item) {
    return new SequenceStatusFluentImpl.AddressNestedImpl(item);
  }
  public SequenceStatusFluent.AddressNested<A> editAddress() {
    return withNewAddressLike(getAddress());
  }
  public SequenceStatusFluent.AddressNested<A> editOrNewAddress() {
    return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
  }
  public SequenceStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item) {
    return withNewAddressLike(getAddress() != null ? getAddress(): item);
  }
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  public A addToChannelStatuses(Integer index,SequenceChannelStatus item) {
    if (this.channelStatuses == null) {this.channelStatuses = new ArrayList<SequenceChannelStatusBuilder>();}
    SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);_visitables.get("channelStatuses").add(index >= 0 ? index : _visitables.get("channelStatuses").size(), builder);this.channelStatuses.add(index >= 0 ? index : channelStatuses.size(), builder); return (A)this;
  }
  public A setToChannelStatuses(Integer index,SequenceChannelStatus item) {
    if (this.channelStatuses == null) {this.channelStatuses = new ArrayList<SequenceChannelStatusBuilder>();}
    SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("channelStatuses").size()) { _visitables.get("channelStatuses").add(builder); } else { _visitables.get("channelStatuses").set(index, builder);}
    if (index < 0 || index >= channelStatuses.size()) { channelStatuses.add(builder); } else { channelStatuses.set(index, builder);}
     return (A)this;
  }
  public A addToChannelStatuses(io.fabric8.knative.flows.v1.SequenceChannelStatus... items) {
    if (this.channelStatuses == null) {this.channelStatuses = new ArrayList<SequenceChannelStatusBuilder>();}
    for (SequenceChannelStatus item : items) {SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);_visitables.get("channelStatuses").add(builder);this.channelStatuses.add(builder);} return (A)this;
  }
  public A addAllToChannelStatuses(Collection<SequenceChannelStatus> items) {
    if (this.channelStatuses == null) {this.channelStatuses = new ArrayList<SequenceChannelStatusBuilder>();}
    for (SequenceChannelStatus item : items) {SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);_visitables.get("channelStatuses").add(builder);this.channelStatuses.add(builder);} return (A)this;
  }
  public A removeFromChannelStatuses(io.fabric8.knative.flows.v1.SequenceChannelStatus... items) {
    for (SequenceChannelStatus item : items) {SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);_visitables.get("channelStatuses").remove(builder);if (this.channelStatuses != null) {this.channelStatuses.remove(builder);}} return (A)this;
  }
  public A removeAllFromChannelStatuses(Collection<SequenceChannelStatus> items) {
    for (SequenceChannelStatus item : items) {SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);_visitables.get("channelStatuses").remove(builder);if (this.channelStatuses != null) {this.channelStatuses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromChannelStatuses(Predicate<SequenceChannelStatusBuilder> predicate) {
    if (channelStatuses == null) return (A) this;
    final Iterator<SequenceChannelStatusBuilder> each = channelStatuses.iterator();
    final List visitables = _visitables.get("channelStatuses");
    while (each.hasNext()) {
      SequenceChannelStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildChannelStatuses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SequenceChannelStatus> getChannelStatuses() {
    return channelStatuses != null ? build(channelStatuses) : null;
  }
  public List<SequenceChannelStatus> buildChannelStatuses() {
    return channelStatuses != null ? build(channelStatuses) : null;
  }
  public SequenceChannelStatus buildChannelStatus(Integer index) {
    return this.channelStatuses.get(index).build();
  }
  public SequenceChannelStatus buildFirstChannelStatus() {
    return this.channelStatuses.get(0).build();
  }
  public SequenceChannelStatus buildLastChannelStatus() {
    return this.channelStatuses.get(channelStatuses.size() - 1).build();
  }
  public SequenceChannelStatus buildMatchingChannelStatus(Predicate<SequenceChannelStatusBuilder> predicate) {
    for (SequenceChannelStatusBuilder item: channelStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingChannelStatus(Predicate<SequenceChannelStatusBuilder> predicate) {
    for (SequenceChannelStatusBuilder item: channelStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withChannelStatuses(List<SequenceChannelStatus> channelStatuses) {
    if (this.channelStatuses != null) { _visitables.get("channelStatuses").removeAll(this.channelStatuses);}
    if (channelStatuses != null) {this.channelStatuses = new ArrayList(); for (SequenceChannelStatus item : channelStatuses){this.addToChannelStatuses(item);}} else { this.channelStatuses = null;} return (A) this;
  }
  public A withChannelStatuses(io.fabric8.knative.flows.v1.SequenceChannelStatus... channelStatuses) {
    if (this.channelStatuses != null) {this.channelStatuses.clear();}
    if (channelStatuses != null) {for (SequenceChannelStatus item :channelStatuses){ this.addToChannelStatuses(item);}} return (A) this;
  }
  public Boolean hasChannelStatuses() {
    return channelStatuses != null && !channelStatuses.isEmpty();
  }
  public SequenceStatusFluent.ChannelStatusesNested<A> addNewChannelStatus() {
    return new SequenceStatusFluentImpl.ChannelStatusesNestedImpl();
  }
  public SequenceStatusFluent.ChannelStatusesNested<A> addNewChannelStatusLike(SequenceChannelStatus item) {
    return new SequenceStatusFluentImpl.ChannelStatusesNestedImpl(-1, item);
  }
  public SequenceStatusFluent.ChannelStatusesNested<A> setNewChannelStatusLike(Integer index,SequenceChannelStatus item) {
    return new SequenceStatusFluentImpl.ChannelStatusesNestedImpl(index, item);
  }
  public SequenceStatusFluent.ChannelStatusesNested<A> editChannelStatus(Integer index) {
    if (channelStatuses.size() <= index) throw new RuntimeException("Can't edit channelStatuses. Index exceeds size.");
    return setNewChannelStatusLike(index, buildChannelStatus(index));
  }
  public SequenceStatusFluent.ChannelStatusesNested<A> editFirstChannelStatus() {
    if (channelStatuses.size() == 0) throw new RuntimeException("Can't edit first channelStatuses. The list is empty.");
    return setNewChannelStatusLike(0, buildChannelStatus(0));
  }
  public SequenceStatusFluent.ChannelStatusesNested<A> editLastChannelStatus() {
    int index = channelStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last channelStatuses. The list is empty.");
    return setNewChannelStatusLike(index, buildChannelStatus(index));
  }
  public SequenceStatusFluent.ChannelStatusesNested<A> editMatchingChannelStatus(Predicate<SequenceChannelStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<channelStatuses.size();i++) { 
    if (predicate.test(channelStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching channelStatuses. No match found.");
    return setNewChannelStatusLike(index, buildChannelStatus(index));
  }
  public A addToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Condition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<Condition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public Condition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public SequenceStatusFluent.ConditionsNested<A> addNewCondition() {
    return new SequenceStatusFluentImpl.ConditionsNestedImpl();
  }
  public SequenceStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
    return new SequenceStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public SequenceStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,Condition item) {
    return new SequenceStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public SequenceStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public SequenceStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public SequenceStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public SequenceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public A addToSubscriptionStatuses(Integer index,SequenceSubscriptionStatus item) {
    if (this.subscriptionStatuses == null) {this.subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>();}
    SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);_visitables.get("subscriptionStatuses").add(index >= 0 ? index : _visitables.get("subscriptionStatuses").size(), builder);this.subscriptionStatuses.add(index >= 0 ? index : subscriptionStatuses.size(), builder); return (A)this;
  }
  public A setToSubscriptionStatuses(Integer index,SequenceSubscriptionStatus item) {
    if (this.subscriptionStatuses == null) {this.subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>();}
    SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("subscriptionStatuses").size()) { _visitables.get("subscriptionStatuses").add(builder); } else { _visitables.get("subscriptionStatuses").set(index, builder);}
    if (index < 0 || index >= subscriptionStatuses.size()) { subscriptionStatuses.add(builder); } else { subscriptionStatuses.set(index, builder);}
     return (A)this;
  }
  public A addToSubscriptionStatuses(io.fabric8.knative.flows.v1.SequenceSubscriptionStatus... items) {
    if (this.subscriptionStatuses == null) {this.subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>();}
    for (SequenceSubscriptionStatus item : items) {SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);_visitables.get("subscriptionStatuses").add(builder);this.subscriptionStatuses.add(builder);} return (A)this;
  }
  public A addAllToSubscriptionStatuses(Collection<SequenceSubscriptionStatus> items) {
    if (this.subscriptionStatuses == null) {this.subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>();}
    for (SequenceSubscriptionStatus item : items) {SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);_visitables.get("subscriptionStatuses").add(builder);this.subscriptionStatuses.add(builder);} return (A)this;
  }
  public A removeFromSubscriptionStatuses(io.fabric8.knative.flows.v1.SequenceSubscriptionStatus... items) {
    for (SequenceSubscriptionStatus item : items) {SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);_visitables.get("subscriptionStatuses").remove(builder);if (this.subscriptionStatuses != null) {this.subscriptionStatuses.remove(builder);}} return (A)this;
  }
  public A removeAllFromSubscriptionStatuses(Collection<SequenceSubscriptionStatus> items) {
    for (SequenceSubscriptionStatus item : items) {SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);_visitables.get("subscriptionStatuses").remove(builder);if (this.subscriptionStatuses != null) {this.subscriptionStatuses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSubscriptionStatuses(Predicate<SequenceSubscriptionStatusBuilder> predicate) {
    if (subscriptionStatuses == null) return (A) this;
    final Iterator<SequenceSubscriptionStatusBuilder> each = subscriptionStatuses.iterator();
    final List visitables = _visitables.get("subscriptionStatuses");
    while (each.hasNext()) {
      SequenceSubscriptionStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSubscriptionStatuses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SequenceSubscriptionStatus> getSubscriptionStatuses() {
    return subscriptionStatuses != null ? build(subscriptionStatuses) : null;
  }
  public List<SequenceSubscriptionStatus> buildSubscriptionStatuses() {
    return subscriptionStatuses != null ? build(subscriptionStatuses) : null;
  }
  public SequenceSubscriptionStatus buildSubscriptionStatus(Integer index) {
    return this.subscriptionStatuses.get(index).build();
  }
  public SequenceSubscriptionStatus buildFirstSubscriptionStatus() {
    return this.subscriptionStatuses.get(0).build();
  }
  public SequenceSubscriptionStatus buildLastSubscriptionStatus() {
    return this.subscriptionStatuses.get(subscriptionStatuses.size() - 1).build();
  }
  public SequenceSubscriptionStatus buildMatchingSubscriptionStatus(Predicate<SequenceSubscriptionStatusBuilder> predicate) {
    for (SequenceSubscriptionStatusBuilder item: subscriptionStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSubscriptionStatus(Predicate<SequenceSubscriptionStatusBuilder> predicate) {
    for (SequenceSubscriptionStatusBuilder item: subscriptionStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubscriptionStatuses(List<SequenceSubscriptionStatus> subscriptionStatuses) {
    if (this.subscriptionStatuses != null) { _visitables.get("subscriptionStatuses").removeAll(this.subscriptionStatuses);}
    if (subscriptionStatuses != null) {this.subscriptionStatuses = new ArrayList(); for (SequenceSubscriptionStatus item : subscriptionStatuses){this.addToSubscriptionStatuses(item);}} else { this.subscriptionStatuses = null;} return (A) this;
  }
  public A withSubscriptionStatuses(io.fabric8.knative.flows.v1.SequenceSubscriptionStatus... subscriptionStatuses) {
    if (this.subscriptionStatuses != null) {this.subscriptionStatuses.clear();}
    if (subscriptionStatuses != null) {for (SequenceSubscriptionStatus item :subscriptionStatuses){ this.addToSubscriptionStatuses(item);}} return (A) this;
  }
  public Boolean hasSubscriptionStatuses() {
    return subscriptionStatuses != null && !subscriptionStatuses.isEmpty();
  }
  public SequenceStatusFluent.SubscriptionStatusesNested<A> addNewSubscriptionStatus() {
    return new SequenceStatusFluentImpl.SubscriptionStatusesNestedImpl();
  }
  public SequenceStatusFluent.SubscriptionStatusesNested<A> addNewSubscriptionStatusLike(SequenceSubscriptionStatus item) {
    return new SequenceStatusFluentImpl.SubscriptionStatusesNestedImpl(-1, item);
  }
  public SequenceStatusFluent.SubscriptionStatusesNested<A> setNewSubscriptionStatusLike(Integer index,SequenceSubscriptionStatus item) {
    return new SequenceStatusFluentImpl.SubscriptionStatusesNestedImpl(index, item);
  }
  public SequenceStatusFluent.SubscriptionStatusesNested<A> editSubscriptionStatus(Integer index) {
    if (subscriptionStatuses.size() <= index) throw new RuntimeException("Can't edit subscriptionStatuses. Index exceeds size.");
    return setNewSubscriptionStatusLike(index, buildSubscriptionStatus(index));
  }
  public SequenceStatusFluent.SubscriptionStatusesNested<A> editFirstSubscriptionStatus() {
    if (subscriptionStatuses.size() == 0) throw new RuntimeException("Can't edit first subscriptionStatuses. The list is empty.");
    return setNewSubscriptionStatusLike(0, buildSubscriptionStatus(0));
  }
  public SequenceStatusFluent.SubscriptionStatusesNested<A> editLastSubscriptionStatus() {
    int index = subscriptionStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subscriptionStatuses. The list is empty.");
    return setNewSubscriptionStatusLike(index, buildSubscriptionStatus(index));
  }
  public SequenceStatusFluent.SubscriptionStatusesNested<A> editMatchingSubscriptionStatus(Predicate<SequenceSubscriptionStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subscriptionStatuses.size();i++) { 
    if (predicate.test(subscriptionStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subscriptionStatuses. No match found.");
    return setNewSubscriptionStatusLike(index, buildSubscriptionStatus(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SequenceStatusFluentImpl that = (SequenceStatusFluentImpl) o;
    if (address != null ? !address.equals(that.address) :that.address != null) return false;
    if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
    if (channelStatuses != null ? !channelStatuses.equals(that.channelStatuses) :that.channelStatuses != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (subscriptionStatuses != null ? !subscriptionStatuses.equals(that.subscriptionStatuses) :that.subscriptionStatuses != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(address,  annotations,  channelStatuses,  conditions,  observedGeneration,  subscriptionStatuses,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (address != null) { sb.append("address:"); sb.append(address + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (channelStatuses != null && !channelStatuses.isEmpty()) { sb.append("channelStatuses:"); sb.append(channelStatuses + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (subscriptionStatuses != null && !subscriptionStatuses.isEmpty()) { sb.append("subscriptionStatuses:"); sb.append(subscriptionStatuses); }
    sb.append("}");
    return sb.toString();
  }
  class AddressNestedImpl<N> extends AddressableFluentImpl<SequenceStatusFluent.AddressNested<N>> implements SequenceStatusFluent.AddressNested<N>,Nested<N>{
    AddressNestedImpl(Addressable item) {
      this.builder = new AddressableBuilder(this, item);
    }
    AddressNestedImpl() {
      this.builder = new AddressableBuilder(this);
    }
    AddressableBuilder builder;
    public N and() {
      return (N) SequenceStatusFluentImpl.this.withAddress(builder.build());
    }
    public N endAddress() {
      return and();
    }
    
  }
  class ChannelStatusesNestedImpl<N> extends SequenceChannelStatusFluentImpl<SequenceStatusFluent.ChannelStatusesNested<N>> implements SequenceStatusFluent.ChannelStatusesNested<N>,Nested<N>{
    ChannelStatusesNestedImpl(Integer index,SequenceChannelStatus item) {
      this.index = index;
      this.builder = new SequenceChannelStatusBuilder(this, item);
    }
    ChannelStatusesNestedImpl() {
      this.index = -1;
      this.builder = new SequenceChannelStatusBuilder(this);
    }
    SequenceChannelStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) SequenceStatusFluentImpl.this.setToChannelStatuses(index,builder.build());
    }
    public N endChannelStatus() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends ConditionFluentImpl<SequenceStatusFluent.ConditionsNested<N>> implements SequenceStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ConditionBuilder(this);
    }
    ConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) SequenceStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class SubscriptionStatusesNestedImpl<N> extends SequenceSubscriptionStatusFluentImpl<SequenceStatusFluent.SubscriptionStatusesNested<N>> implements SequenceStatusFluent.SubscriptionStatusesNested<N>,Nested<N>{
    SubscriptionStatusesNestedImpl(Integer index,SequenceSubscriptionStatus item) {
      this.index = index;
      this.builder = new SequenceSubscriptionStatusBuilder(this, item);
    }
    SubscriptionStatusesNestedImpl() {
      this.index = -1;
      this.builder = new SequenceSubscriptionStatusBuilder(this);
    }
    SequenceSubscriptionStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) SequenceStatusFluentImpl.this.setToSubscriptionStatuses(index,builder.build());
    }
    public N endSubscriptionStatus() {
      return and();
    }
    
  }
  
}