package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SequenceSpecBuilder extends SequenceSpecFluentImpl<SequenceSpecBuilder> implements VisitableBuilder<SequenceSpec,SequenceSpecBuilder>{
  public SequenceSpecBuilder() {
    this(false);
  }
  public SequenceSpecBuilder(Boolean validationEnabled) {
    this(new SequenceSpec(), validationEnabled);
  }
  public SequenceSpecBuilder(SequenceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SequenceSpecBuilder(SequenceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SequenceSpec(), validationEnabled);
  }
  public SequenceSpecBuilder(SequenceSpecFluent<?> fluent,SequenceSpec instance) {
    this(fluent, instance, false);
  }
  public SequenceSpecBuilder(SequenceSpecFluent<?> fluent,SequenceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withChannelTemplate(instance.getChannelTemplate()); 
    fluent.withReply(instance.getReply()); 
    fluent.withSteps(instance.getSteps()); 
    this.validationEnabled = validationEnabled; 
  }
  public SequenceSpecBuilder(SequenceSpec instance) {
    this(instance,false);
  }
  public SequenceSpecBuilder(SequenceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withChannelTemplate(instance.getChannelTemplate()); 
    this.withReply(instance.getReply()); 
    this.withSteps(instance.getSteps()); 
    this.validationEnabled = validationEnabled; 
  }
  SequenceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SequenceSpec build() {
    SequenceSpec buildable = new SequenceSpec(fluent.getChannelTemplate(),fluent.getReply(),fluent.getSteps());
    return buildable;
  }
  
}