package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitHubSourceSpecBuilder extends GitHubSourceSpecFluentImpl<GitHubSourceSpecBuilder> implements VisitableBuilder<GitHubSourceSpec,GitHubSourceSpecBuilder>{
  public GitHubSourceSpecBuilder() {
    this(false);
  }
  public GitHubSourceSpecBuilder(Boolean validationEnabled) {
    this(new GitHubSourceSpec(), validationEnabled);
  }
  public GitHubSourceSpecBuilder(GitHubSourceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public GitHubSourceSpecBuilder(GitHubSourceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitHubSourceSpec(), validationEnabled);
  }
  public GitHubSourceSpecBuilder(GitHubSourceSpecFluent<?> fluent,GitHubSourceSpec instance) {
    this(fluent, instance, false);
  }
  public GitHubSourceSpecBuilder(GitHubSourceSpecFluent<?> fluent,GitHubSourceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAccessToken(instance.getAccessToken()); 
    fluent.withCeOverrides(instance.getCeOverrides()); 
    fluent.withEventTypes(instance.getEventTypes()); 
    fluent.withGithubAPIURL(instance.getGithubAPIURL()); 
    fluent.withOwnerAndRepository(instance.getOwnerAndRepository()); 
    fluent.withSecretToken(instance.getSecretToken()); 
    fluent.withSecure(instance.getSecure()); 
    fluent.withServiceAccountName(instance.getServiceAccountName()); 
    fluent.withSink(instance.getSink()); 
    this.validationEnabled = validationEnabled; 
  }
  public GitHubSourceSpecBuilder(GitHubSourceSpec instance) {
    this(instance,false);
  }
  public GitHubSourceSpecBuilder(GitHubSourceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAccessToken(instance.getAccessToken()); 
    this.withCeOverrides(instance.getCeOverrides()); 
    this.withEventTypes(instance.getEventTypes()); 
    this.withGithubAPIURL(instance.getGithubAPIURL()); 
    this.withOwnerAndRepository(instance.getOwnerAndRepository()); 
    this.withSecretToken(instance.getSecretToken()); 
    this.withSecure(instance.getSecure()); 
    this.withServiceAccountName(instance.getServiceAccountName()); 
    this.withSink(instance.getSink()); 
    this.validationEnabled = validationEnabled; 
  }
  GitHubSourceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public GitHubSourceSpec build() {
    GitHubSourceSpec buildable = new GitHubSourceSpec(fluent.getAccessToken(),fluent.getCeOverrides(),fluent.getEventTypes(),fluent.getGithubAPIURL(),fluent.getOwnerAndRepository(),fluent.getSecretToken(),fluent.getSecure(),fluent.getServiceAccountName(),fluent.getSink());
    return buildable;
  }
  
}