package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitHubBindingListBuilder extends GitHubBindingListFluentImpl<GitHubBindingListBuilder> implements VisitableBuilder<GitHubBindingList,GitHubBindingListBuilder>{
  public GitHubBindingListBuilder() {
    this(false);
  }
  public GitHubBindingListBuilder(Boolean validationEnabled) {
    this(new GitHubBindingList(), validationEnabled);
  }
  public GitHubBindingListBuilder(GitHubBindingListFluent<?> fluent) {
    this(fluent, false);
  }
  public GitHubBindingListBuilder(GitHubBindingListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitHubBindingList(), validationEnabled);
  }
  public GitHubBindingListBuilder(GitHubBindingListFluent<?> fluent,GitHubBindingList instance) {
    this(fluent, instance, false);
  }
  public GitHubBindingListBuilder(GitHubBindingListFluent<?> fluent,GitHubBindingList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public GitHubBindingListBuilder(GitHubBindingList instance) {
    this(instance,false);
  }
  public GitHubBindingListBuilder(GitHubBindingList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  GitHubBindingListFluent<?> fluent;
  Boolean validationEnabled;
  public GitHubBindingList build() {
    GitHubBindingList buildable = new GitHubBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}