package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PingSourceListBuilder extends PingSourceListFluentImpl<PingSourceListBuilder> implements VisitableBuilder<PingSourceList,PingSourceListBuilder>{
  public PingSourceListBuilder() {
    this(false);
  }
  public PingSourceListBuilder(Boolean validationEnabled) {
    this(new PingSourceList(), validationEnabled);
  }
  public PingSourceListBuilder(PingSourceListFluent<?> fluent) {
    this(fluent, false);
  }
  public PingSourceListBuilder(PingSourceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PingSourceList(), validationEnabled);
  }
  public PingSourceListBuilder(PingSourceListFluent<?> fluent,PingSourceList instance) {
    this(fluent, instance, false);
  }
  public PingSourceListBuilder(PingSourceListFluent<?> fluent,PingSourceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public PingSourceListBuilder(PingSourceList instance) {
    this(instance,false);
  }
  public PingSourceListBuilder(PingSourceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  PingSourceListFluent<?> fluent;
  Boolean validationEnabled;
  public PingSourceList build() {
    PingSourceList buildable = new PingSourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}