package io.fabric8.knative.sources.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PingSourceFluentImpl<A extends PingSourceFluent<A>> extends BaseFluent<A> implements PingSourceFluent<A>{
  public PingSourceFluentImpl() {
  }
  public PingSourceFluentImpl(PingSource instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private PingSourceSpecBuilder spec;
  private PingSourceStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public PingSourceFluent.MetadataNested<A> withNewMetadata() {
    return new PingSourceFluentImpl.MetadataNestedImpl();
  }
  public PingSourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new PingSourceFluentImpl.MetadataNestedImpl(item);
  }
  public PingSourceFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public PingSourceFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public PingSourceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public PingSourceSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public PingSourceSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(PingSourceSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new PingSourceSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public PingSourceFluent.SpecNested<A> withNewSpec() {
    return new PingSourceFluentImpl.SpecNestedImpl();
  }
  public PingSourceFluent.SpecNested<A> withNewSpecLike(PingSourceSpec item) {
    return new PingSourceFluentImpl.SpecNestedImpl(item);
  }
  public PingSourceFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public PingSourceFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new PingSourceSpecBuilder().build());
  }
  public PingSourceFluent.SpecNested<A> editOrNewSpecLike(PingSourceSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public PingSourceStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public PingSourceStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(PingSourceStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new PingSourceStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public PingSourceFluent.StatusNested<A> withNewStatus() {
    return new PingSourceFluentImpl.StatusNestedImpl();
  }
  public PingSourceFluent.StatusNested<A> withNewStatusLike(PingSourceStatus item) {
    return new PingSourceFluentImpl.StatusNestedImpl(item);
  }
  public PingSourceFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public PingSourceFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new PingSourceStatusBuilder().build());
  }
  public PingSourceFluent.StatusNested<A> editOrNewStatusLike(PingSourceStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PingSourceFluentImpl that = (PingSourceFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<PingSourceFluent.MetadataNested<N>> implements PingSourceFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) PingSourceFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends PingSourceSpecFluentImpl<PingSourceFluent.SpecNested<N>> implements PingSourceFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(PingSourceSpec item) {
      this.builder = new PingSourceSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new PingSourceSpecBuilder(this);
    }
    PingSourceSpecBuilder builder;
    public N and() {
      return (N) PingSourceFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends PingSourceStatusFluentImpl<PingSourceFluent.StatusNested<N>> implements PingSourceFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(PingSourceStatus item) {
      this.builder = new PingSourceStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new PingSourceStatusBuilder(this);
    }
    PingSourceStatusBuilder builder;
    public N and() {
      return (N) PingSourceFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}