package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TrafficTargetBuilder extends TrafficTargetFluentImpl<TrafficTargetBuilder> implements VisitableBuilder<TrafficTarget,TrafficTargetBuilder>{
  public TrafficTargetBuilder() {
    this(false);
  }
  public TrafficTargetBuilder(Boolean validationEnabled) {
    this(new TrafficTarget(), validationEnabled);
  }
  public TrafficTargetBuilder(TrafficTargetFluent<?> fluent) {
    this(fluent, false);
  }
  public TrafficTargetBuilder(TrafficTargetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TrafficTarget(), validationEnabled);
  }
  public TrafficTargetBuilder(TrafficTargetFluent<?> fluent,TrafficTarget instance) {
    this(fluent, instance, false);
  }
  public TrafficTargetBuilder(TrafficTargetFluent<?> fluent,TrafficTarget instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigurationName(instance.getConfigurationName()); 
    fluent.withLatestRevision(instance.getLatestRevision()); 
    fluent.withPercent(instance.getPercent()); 
    fluent.withRevisionName(instance.getRevisionName()); 
    fluent.withTag(instance.getTag()); 
    fluent.withUrl(instance.getUrl()); 
    this.validationEnabled = validationEnabled; 
  }
  public TrafficTargetBuilder(TrafficTarget instance) {
    this(instance,false);
  }
  public TrafficTargetBuilder(TrafficTarget instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigurationName(instance.getConfigurationName()); 
    this.withLatestRevision(instance.getLatestRevision()); 
    this.withPercent(instance.getPercent()); 
    this.withRevisionName(instance.getRevisionName()); 
    this.withTag(instance.getTag()); 
    this.withUrl(instance.getUrl()); 
    this.validationEnabled = validationEnabled; 
  }
  TrafficTargetFluent<?> fluent;
  Boolean validationEnabled;
  public TrafficTarget build() {
    TrafficTarget buildable = new TrafficTarget(fluent.getConfigurationName(),fluent.getLatestRevision(),fluent.getPercent(),fluent.getRevisionName(),fluent.getTag(),fluent.getUrl());
    return buildable;
  }
  
}