package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.PodOS;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PodReadinessGate;
import io.fabric8.kubernetes.api.model.HostAlias;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RevisionSpecFluentImpl<A extends RevisionSpecFluent<A>> extends BaseFluent<A> implements RevisionSpecFluent<A>{
  public RevisionSpecFluentImpl() {
  }
  public RevisionSpecFluentImpl(RevisionSpec instance) {
    this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
    this.withAffinity(instance.getAffinity()); 
    this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken()); 
    this.withContainerConcurrency(instance.getContainerConcurrency()); 
    this.withContainers(instance.getContainers()); 
    this.withDnsConfig(instance.getDnsConfig()); 
    this.withDnsPolicy(instance.getDnsPolicy()); 
    this.withEnableServiceLinks(instance.getEnableServiceLinks()); 
    this.withEphemeralContainers(instance.getEphemeralContainers()); 
    this.withHostAliases(instance.getHostAliases()); 
    this.withHostIPC(instance.getHostIPC()); 
    this.withHostNetwork(instance.getHostNetwork()); 
    this.withHostPID(instance.getHostPID()); 
    this.withHostname(instance.getHostname()); 
    this.withIdleTimeoutSeconds(instance.getIdleTimeoutSeconds()); 
    this.withImagePullSecrets(instance.getImagePullSecrets()); 
    this.withInitContainers(instance.getInitContainers()); 
    this.withNodeName(instance.getNodeName()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withOs(instance.getOs()); 
    this.withOverhead(instance.getOverhead()); 
    this.withPreemptionPolicy(instance.getPreemptionPolicy()); 
    this.withPriority(instance.getPriority()); 
    this.withPriorityClassName(instance.getPriorityClassName()); 
    this.withReadinessGates(instance.getReadinessGates()); 
    this.withResponseStartTimeoutSeconds(instance.getResponseStartTimeoutSeconds()); 
    this.withRestartPolicy(instance.getRestartPolicy()); 
    this.withRuntimeClassName(instance.getRuntimeClassName()); 
    this.withSchedulerName(instance.getSchedulerName()); 
    this.withSecurityContext(instance.getSecurityContext()); 
    this.withServiceAccount(instance.getServiceAccount()); 
    this.withServiceAccountName(instance.getServiceAccountName()); 
    this.withSetHostnameAsFQDN(instance.getSetHostnameAsFQDN()); 
    this.withShareProcessNamespace(instance.getShareProcessNamespace()); 
    this.withSubdomain(instance.getSubdomain()); 
    this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); 
    this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
    this.withTolerations(instance.getTolerations()); 
    this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints()); 
    this.withVolumes(instance.getVolumes()); 
  }
  private Long activeDeadlineSeconds;
  private Affinity affinity;
  private Boolean automountServiceAccountToken;
  private Long containerConcurrency;
  private ArrayList<ContainerBuilder> containers = new ArrayList<ContainerBuilder>();
  private PodDNSConfig dnsConfig;
  private String dnsPolicy;
  private Boolean enableServiceLinks;
  private List<EphemeralContainer> ephemeralContainers = new ArrayList<EphemeralContainer>();
  private List<HostAlias> hostAliases = new ArrayList<HostAlias>();
  private Boolean hostIPC;
  private Boolean hostNetwork;
  private Boolean hostPID;
  private String hostname;
  private Long idleTimeoutSeconds;
  private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
  private ArrayList<ContainerBuilder> initContainers = new ArrayList<ContainerBuilder>();
  private String nodeName;
  private Map<String,String> nodeSelector;
  private PodOS os;
  private Map<String,Quantity> overhead;
  private String preemptionPolicy;
  private Integer priority;
  private String priorityClassName;
  private List<PodReadinessGate> readinessGates = new ArrayList<PodReadinessGate>();
  private Long responseStartTimeoutSeconds;
  private String restartPolicy;
  private String runtimeClassName;
  private String schedulerName;
  private PodSecurityContext securityContext;
  private String serviceAccount;
  private String serviceAccountName;
  private Boolean setHostnameAsFQDN;
  private Boolean shareProcessNamespace;
  private String subdomain;
  private Long terminationGracePeriodSeconds;
  private Long timeoutSeconds;
  private List<Toleration> tolerations = new ArrayList<Toleration>();
  private List<TopologySpreadConstraint> topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
  private ArrayList<VolumeBuilder> volumes = new ArrayList<VolumeBuilder>();
  public Long getActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds;
  }
  public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
    this.activeDeadlineSeconds=activeDeadlineSeconds; return (A) this;
  }
  public Boolean hasActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds != null;
  }
  public Affinity getAffinity() {
    return this.affinity;
  }
  public A withAffinity(Affinity affinity) {
    this.affinity=affinity; return (A) this;
  }
  public Boolean hasAffinity() {
    return this.affinity != null;
  }
  public Boolean getAutomountServiceAccountToken() {
    return this.automountServiceAccountToken;
  }
  public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
    this.automountServiceAccountToken=automountServiceAccountToken; return (A) this;
  }
  public Boolean hasAutomountServiceAccountToken() {
    return this.automountServiceAccountToken != null;
  }
  public Long getContainerConcurrency() {
    return this.containerConcurrency;
  }
  public A withContainerConcurrency(Long containerConcurrency) {
    this.containerConcurrency=containerConcurrency; return (A) this;
  }
  public Boolean hasContainerConcurrency() {
    return this.containerConcurrency != null;
  }
  public A addToContainers(Integer index,Container item) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(index >= 0 ? index : _visitables.get("containers").size(), builder);this.containers.add(index >= 0 ? index : containers.size(), builder); return (A)this;
  }
  public A setToContainers(Integer index,Container item) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("containers").size()) { _visitables.get("containers").add(builder); } else { _visitables.get("containers").set(index, builder);}
    if (index < 0 || index >= containers.size()) { containers.add(builder); } else { containers.set(index, builder);}
     return (A)this;
  }
  public A addToContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A addAllToContainers(Collection<Container> items) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A removeFromContainers(io.fabric8.kubernetes.api.model.Container... items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainers(Collection<Container> items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
    if (containers == null) return (A) this;
    final Iterator<ContainerBuilder> each = containers.iterator();
    final List visitables = _visitables.get("containers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getContainers() {
    return containers != null ? build(containers) : null;
  }
  public List<Container> buildContainers() {
    return containers != null ? build(containers) : null;
  }
  public Container buildContainer(Integer index) {
    return this.containers.get(index).build();
  }
  public Container buildFirstContainer() {
    return this.containers.get(0).build();
  }
  public Container buildLastContainer() {
    return this.containers.get(containers.size() - 1).build();
  }
  public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: containers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: containers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainers(List<Container> containers) {
    if (this.containers != null) { _visitables.get("containers").removeAll(this.containers);}
    if (containers != null) {this.containers = new ArrayList(); for (Container item : containers){this.addToContainers(item);}} else { this.containers = null;} return (A) this;
  }
  public A withContainers(io.fabric8.kubernetes.api.model.Container... containers) {
    if (this.containers != null) {this.containers.clear();}
    if (containers != null) {for (Container item :containers){ this.addToContainers(item);}} return (A) this;
  }
  public Boolean hasContainers() {
    return containers != null && !containers.isEmpty();
  }
  public RevisionSpecFluent.ContainersNested<A> addNewContainer() {
    return new RevisionSpecFluentImpl.ContainersNestedImpl();
  }
  public RevisionSpecFluent.ContainersNested<A> addNewContainerLike(Container item) {
    return new RevisionSpecFluentImpl.ContainersNestedImpl(-1, item);
  }
  public RevisionSpecFluent.ContainersNested<A> setNewContainerLike(Integer index,Container item) {
    return new RevisionSpecFluentImpl.ContainersNestedImpl(index, item);
  }
  public RevisionSpecFluent.ContainersNested<A> editContainer(Integer index) {
    if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public RevisionSpecFluent.ContainersNested<A> editFirstContainer() {
    if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
    return setNewContainerLike(0, buildContainer(0));
  }
  public RevisionSpecFluent.ContainersNested<A> editLastContainer() {
    int index = containers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public RevisionSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containers.size();i++) { 
    if (predicate.test(containers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public PodDNSConfig getDnsConfig() {
    return this.dnsConfig;
  }
  public A withDnsConfig(PodDNSConfig dnsConfig) {
    this.dnsConfig=dnsConfig; return (A) this;
  }
  public Boolean hasDnsConfig() {
    return this.dnsConfig != null;
  }
  public String getDnsPolicy() {
    return this.dnsPolicy;
  }
  public A withDnsPolicy(String dnsPolicy) {
    this.dnsPolicy=dnsPolicy; return (A) this;
  }
  public Boolean hasDnsPolicy() {
    return this.dnsPolicy != null;
  }
  public Boolean getEnableServiceLinks() {
    return this.enableServiceLinks;
  }
  public A withEnableServiceLinks(Boolean enableServiceLinks) {
    this.enableServiceLinks=enableServiceLinks; return (A) this;
  }
  public Boolean hasEnableServiceLinks() {
    return this.enableServiceLinks != null;
  }
  public A addToEphemeralContainers(Integer index,EphemeralContainer item) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainer>();}
    this.ephemeralContainers.add(index, item);
    return (A)this;
  }
  public A setToEphemeralContainers(Integer index,EphemeralContainer item) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainer>();}
    this.ephemeralContainers.set(index, item); return (A)this;
  }
  public A addToEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainer>();}
    for (EphemeralContainer item : items) {this.ephemeralContainers.add(item);} return (A)this;
  }
  public A addAllToEphemeralContainers(Collection<EphemeralContainer> items) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainer>();}
    for (EphemeralContainer item : items) {this.ephemeralContainers.add(item);} return (A)this;
  }
  public A removeFromEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items) {
    for (EphemeralContainer item : items) {if (this.ephemeralContainers!= null){ this.ephemeralContainers.remove(item);}} return (A)this;
  }
  public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items) {
    for (EphemeralContainer item : items) {if (this.ephemeralContainers!= null){ this.ephemeralContainers.remove(item);}} return (A)this;
  }
  public List<EphemeralContainer> getEphemeralContainers() {
    return this.ephemeralContainers;
  }
  public EphemeralContainer getEphemeralContainer(Integer index) {
    return this.ephemeralContainers.get(index);
  }
  public EphemeralContainer getFirstEphemeralContainer() {
    return this.ephemeralContainers.get(0);
  }
  public EphemeralContainer getLastEphemeralContainer() {
    return this.ephemeralContainers.get(ephemeralContainers.size() - 1);
  }
  public EphemeralContainer getMatchingEphemeralContainer(Predicate<EphemeralContainer> predicate) {
    for (EphemeralContainer item: ephemeralContainers) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEphemeralContainer(Predicate<EphemeralContainer> predicate) {
    for (EphemeralContainer item: ephemeralContainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers) {
    if (ephemeralContainers != null) {this.ephemeralContainers = new ArrayList(); for (EphemeralContainer item : ephemeralContainers){this.addToEphemeralContainers(item);}} else { this.ephemeralContainers = null;} return (A) this;
  }
  public A withEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... ephemeralContainers) {
    if (this.ephemeralContainers != null) {this.ephemeralContainers.clear();}
    if (ephemeralContainers != null) {for (EphemeralContainer item :ephemeralContainers){ this.addToEphemeralContainers(item);}} return (A) this;
  }
  public Boolean hasEphemeralContainers() {
    return ephemeralContainers != null && !ephemeralContainers.isEmpty();
  }
  public A addToHostAliases(Integer index,HostAlias item) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
    this.hostAliases.add(index, item);
    return (A)this;
  }
  public A setToHostAliases(Integer index,HostAlias item) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
    this.hostAliases.set(index, item); return (A)this;
  }
  public A addToHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
    for (HostAlias item : items) {this.hostAliases.add(item);} return (A)this;
  }
  public A addAllToHostAliases(Collection<HostAlias> items) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
    for (HostAlias item : items) {this.hostAliases.add(item);} return (A)this;
  }
  public A removeFromHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items) {
    for (HostAlias item : items) {if (this.hostAliases!= null){ this.hostAliases.remove(item);}} return (A)this;
  }
  public A removeAllFromHostAliases(Collection<HostAlias> items) {
    for (HostAlias item : items) {if (this.hostAliases!= null){ this.hostAliases.remove(item);}} return (A)this;
  }
  public List<HostAlias> getHostAliases() {
    return this.hostAliases;
  }
  public HostAlias getHostAlias(Integer index) {
    return this.hostAliases.get(index);
  }
  public HostAlias getFirstHostAlias() {
    return this.hostAliases.get(0);
  }
  public HostAlias getLastHostAlias() {
    return this.hostAliases.get(hostAliases.size() - 1);
  }
  public HostAlias getMatchingHostAlias(Predicate<HostAlias> predicate) {
    for (HostAlias item: hostAliases) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingHostAlias(Predicate<HostAlias> predicate) {
    for (HostAlias item: hostAliases) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHostAliases(List<HostAlias> hostAliases) {
    if (hostAliases != null) {this.hostAliases = new ArrayList(); for (HostAlias item : hostAliases){this.addToHostAliases(item);}} else { this.hostAliases = null;} return (A) this;
  }
  public A withHostAliases(io.fabric8.kubernetes.api.model.HostAlias... hostAliases) {
    if (this.hostAliases != null) {this.hostAliases.clear();}
    if (hostAliases != null) {for (HostAlias item :hostAliases){ this.addToHostAliases(item);}} return (A) this;
  }
  public Boolean hasHostAliases() {
    return hostAliases != null && !hostAliases.isEmpty();
  }
  public Boolean getHostIPC() {
    return this.hostIPC;
  }
  public A withHostIPC(Boolean hostIPC) {
    this.hostIPC=hostIPC; return (A) this;
  }
  public Boolean hasHostIPC() {
    return this.hostIPC != null;
  }
  public Boolean getHostNetwork() {
    return this.hostNetwork;
  }
  public A withHostNetwork(Boolean hostNetwork) {
    this.hostNetwork=hostNetwork; return (A) this;
  }
  public Boolean hasHostNetwork() {
    return this.hostNetwork != null;
  }
  public Boolean getHostPID() {
    return this.hostPID;
  }
  public A withHostPID(Boolean hostPID) {
    this.hostPID=hostPID; return (A) this;
  }
  public Boolean hasHostPID() {
    return this.hostPID != null;
  }
  public String getHostname() {
    return this.hostname;
  }
  public A withHostname(String hostname) {
    this.hostname=hostname; return (A) this;
  }
  public Boolean hasHostname() {
    return this.hostname != null;
  }
  public Long getIdleTimeoutSeconds() {
    return this.idleTimeoutSeconds;
  }
  public A withIdleTimeoutSeconds(Long idleTimeoutSeconds) {
    this.idleTimeoutSeconds=idleTimeoutSeconds; return (A) this;
  }
  public Boolean hasIdleTimeoutSeconds() {
    return this.idleTimeoutSeconds != null;
  }
  public A addToImagePullSecrets(Integer index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(index >= 0 ? index : _visitables.get("imagePullSecrets").size(), builder);this.imagePullSecrets.add(index >= 0 ? index : imagePullSecrets.size(), builder); return (A)this;
  }
  public A setToImagePullSecrets(Integer index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("imagePullSecrets").size()) { _visitables.get("imagePullSecrets").add(builder); } else { _visitables.get("imagePullSecrets").set(index, builder);}
    if (index < 0 || index >= imagePullSecrets.size()) { imagePullSecrets.add(builder); } else { imagePullSecrets.set(index, builder);}
     return (A)this;
  }
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
  }
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (imagePullSecrets == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = imagePullSecrets.iterator();
    final List visitables = _visitables.get("imagePullSecrets");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImagePullSecrets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LocalObjectReference> getImagePullSecrets() {
    return imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  public List<LocalObjectReference> buildImagePullSecrets() {
    return imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  public LocalObjectReference buildImagePullSecret(Integer index) {
    return this.imagePullSecrets.get(index).build();
  }
  public LocalObjectReference buildFirstImagePullSecret() {
    return this.imagePullSecrets.get(0).build();
  }
  public LocalObjectReference buildLastImagePullSecret() {
    return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
  }
  public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
    if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);}
    if (imagePullSecrets != null) {this.imagePullSecrets = new ArrayList(); for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
  }
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets) {
    if (this.imagePullSecrets != null) {this.imagePullSecrets.clear();}
    if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
  }
  public Boolean hasImagePullSecrets() {
    return imagePullSecrets != null && !imagePullSecrets.isEmpty();
  }
  public A addNewImagePullSecret(String name) {
    return (A)addToImagePullSecrets(new LocalObjectReference(name));
  }
  public RevisionSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
    return new RevisionSpecFluentImpl.ImagePullSecretsNestedImpl();
  }
  public RevisionSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
    return new RevisionSpecFluentImpl.ImagePullSecretsNestedImpl(-1, item);
  }
  public RevisionSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(Integer index,LocalObjectReference item) {
    return new RevisionSpecFluentImpl.ImagePullSecretsNestedImpl(index, item);
  }
  public RevisionSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(Integer index) {
    if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public RevisionSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
    if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(0, buildImagePullSecret(0));
  }
  public RevisionSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
    int index = imagePullSecrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public RevisionSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imagePullSecrets.size();i++) { 
    if (predicate.test(imagePullSecrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public A addToInitContainers(Integer index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(index >= 0 ? index : _visitables.get("initContainers").size(), builder);this.initContainers.add(index >= 0 ? index : initContainers.size(), builder); return (A)this;
  }
  public A setToInitContainers(Integer index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("initContainers").size()) { _visitables.get("initContainers").add(builder); } else { _visitables.get("initContainers").set(index, builder);}
    if (index < 0 || index >= initContainers.size()) { initContainers.add(builder); } else { initContainers.set(index, builder);}
     return (A)this;
  }
  public A addToInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A addAllToInitContainers(Collection<Container> items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A removeFromInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromInitContainers(Collection<Container> items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
    if (initContainers == null) return (A) this;
    final Iterator<ContainerBuilder> each = initContainers.iterator();
    final List visitables = _visitables.get("initContainers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getInitContainers() {
    return initContainers != null ? build(initContainers) : null;
  }
  public List<Container> buildInitContainers() {
    return initContainers != null ? build(initContainers) : null;
  }
  public Container buildInitContainer(Integer index) {
    return this.initContainers.get(index).build();
  }
  public Container buildFirstInitContainer() {
    return this.initContainers.get(0).build();
  }
  public Container buildLastInitContainer() {
    return this.initContainers.get(initContainers.size() - 1).build();
  }
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInitContainers(List<Container> initContainers) {
    if (this.initContainers != null) { _visitables.get("initContainers").removeAll(this.initContainers);}
    if (initContainers != null) {this.initContainers = new ArrayList(); for (Container item : initContainers){this.addToInitContainers(item);}} else { this.initContainers = null;} return (A) this;
  }
  public A withInitContainers(io.fabric8.kubernetes.api.model.Container... initContainers) {
    if (this.initContainers != null) {this.initContainers.clear();}
    if (initContainers != null) {for (Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
  }
  public Boolean hasInitContainers() {
    return initContainers != null && !initContainers.isEmpty();
  }
  public RevisionSpecFluent.InitContainersNested<A> addNewInitContainer() {
    return new RevisionSpecFluentImpl.InitContainersNestedImpl();
  }
  public RevisionSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
    return new RevisionSpecFluentImpl.InitContainersNestedImpl(-1, item);
  }
  public RevisionSpecFluent.InitContainersNested<A> setNewInitContainerLike(Integer index,Container item) {
    return new RevisionSpecFluentImpl.InitContainersNestedImpl(index, item);
  }
  public RevisionSpecFluent.InitContainersNested<A> editInitContainer(Integer index) {
    if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public RevisionSpecFluent.InitContainersNested<A> editFirstInitContainer() {
    if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
    return setNewInitContainerLike(0, buildInitContainer(0));
  }
  public RevisionSpecFluent.InitContainersNested<A> editLastInitContainer() {
    int index = initContainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public RevisionSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainers.size();i++) { 
    if (predicate.test(initContainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public String getNodeName() {
    return this.nodeName;
  }
  public A withNodeName(String nodeName) {
    this.nodeName=nodeName; return (A) this;
  }
  public Boolean hasNodeName() {
    return this.nodeName != null;
  }
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap(nodeSelector);} return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  public PodOS getOs() {
    return this.os;
  }
  public A withOs(PodOS os) {
    this.os=os; return (A) this;
  }
  public Boolean hasOs() {
    return this.os != null;
  }
  public A withNewOs(String name) {
    return (A)withOs(new PodOS(name));
  }
  public A addToOverhead(String key,Quantity value) {
    if(this.overhead == null && key != null && value != null) { this.overhead = new LinkedHashMap(); }
    if(key != null && value != null) {this.overhead.put(key, value);} return (A)this;
  }
  public A addToOverhead(Map<String,Quantity> map) {
    if(this.overhead == null && map != null) { this.overhead = new LinkedHashMap(); }
    if(map != null) { this.overhead.putAll(map);} return (A)this;
  }
  public A removeFromOverhead(String key) {
    if(this.overhead == null) { return (A) this; }
    if(key != null && this.overhead != null) {this.overhead.remove(key);} return (A)this;
  }
  public A removeFromOverhead(Map<String,Quantity> map) {
    if(this.overhead == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.overhead != null){this.overhead.remove(key);}}} return (A)this;
  }
  public Map<String,Quantity> getOverhead() {
    return this.overhead;
  }
  public <K,V>A withOverhead(Map<String,Quantity> overhead) {
    if (overhead == null) { this.overhead =  null;} else {this.overhead = new LinkedHashMap(overhead);} return (A) this;
  }
  public Boolean hasOverhead() {
    return this.overhead != null;
  }
  public String getPreemptionPolicy() {
    return this.preemptionPolicy;
  }
  public A withPreemptionPolicy(String preemptionPolicy) {
    this.preemptionPolicy=preemptionPolicy; return (A) this;
  }
  public Boolean hasPreemptionPolicy() {
    return this.preemptionPolicy != null;
  }
  public Integer getPriority() {
    return this.priority;
  }
  public A withPriority(Integer priority) {
    this.priority=priority; return (A) this;
  }
  public Boolean hasPriority() {
    return this.priority != null;
  }
  public String getPriorityClassName() {
    return this.priorityClassName;
  }
  public A withPriorityClassName(String priorityClassName) {
    this.priorityClassName=priorityClassName; return (A) this;
  }
  public Boolean hasPriorityClassName() {
    return this.priorityClassName != null;
  }
  public A addToReadinessGates(Integer index,PodReadinessGate item) {
    if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGate>();}
    this.readinessGates.add(index, item);
    return (A)this;
  }
  public A setToReadinessGates(Integer index,PodReadinessGate item) {
    if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGate>();}
    this.readinessGates.set(index, item); return (A)this;
  }
  public A addToReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... items) {
    if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGate>();}
    for (PodReadinessGate item : items) {this.readinessGates.add(item);} return (A)this;
  }
  public A addAllToReadinessGates(Collection<PodReadinessGate> items) {
    if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGate>();}
    for (PodReadinessGate item : items) {this.readinessGates.add(item);} return (A)this;
  }
  public A removeFromReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... items) {
    for (PodReadinessGate item : items) {if (this.readinessGates!= null){ this.readinessGates.remove(item);}} return (A)this;
  }
  public A removeAllFromReadinessGates(Collection<PodReadinessGate> items) {
    for (PodReadinessGate item : items) {if (this.readinessGates!= null){ this.readinessGates.remove(item);}} return (A)this;
  }
  public List<PodReadinessGate> getReadinessGates() {
    return this.readinessGates;
  }
  public PodReadinessGate getReadinessGate(Integer index) {
    return this.readinessGates.get(index);
  }
  public PodReadinessGate getFirstReadinessGate() {
    return this.readinessGates.get(0);
  }
  public PodReadinessGate getLastReadinessGate() {
    return this.readinessGates.get(readinessGates.size() - 1);
  }
  public PodReadinessGate getMatchingReadinessGate(Predicate<PodReadinessGate> predicate) {
    for (PodReadinessGate item: readinessGates) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingReadinessGate(Predicate<PodReadinessGate> predicate) {
    for (PodReadinessGate item: readinessGates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withReadinessGates(List<PodReadinessGate> readinessGates) {
    if (readinessGates != null) {this.readinessGates = new ArrayList(); for (PodReadinessGate item : readinessGates){this.addToReadinessGates(item);}} else { this.readinessGates = null;} return (A) this;
  }
  public A withReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... readinessGates) {
    if (this.readinessGates != null) {this.readinessGates.clear();}
    if (readinessGates != null) {for (PodReadinessGate item :readinessGates){ this.addToReadinessGates(item);}} return (A) this;
  }
  public Boolean hasReadinessGates() {
    return readinessGates != null && !readinessGates.isEmpty();
  }
  public A addNewReadinessGate(String conditionType) {
    return (A)addToReadinessGates(new PodReadinessGate(conditionType));
  }
  public Long getResponseStartTimeoutSeconds() {
    return this.responseStartTimeoutSeconds;
  }
  public A withResponseStartTimeoutSeconds(Long responseStartTimeoutSeconds) {
    this.responseStartTimeoutSeconds=responseStartTimeoutSeconds; return (A) this;
  }
  public Boolean hasResponseStartTimeoutSeconds() {
    return this.responseStartTimeoutSeconds != null;
  }
  public String getRestartPolicy() {
    return this.restartPolicy;
  }
  public A withRestartPolicy(String restartPolicy) {
    this.restartPolicy=restartPolicy; return (A) this;
  }
  public Boolean hasRestartPolicy() {
    return this.restartPolicy != null;
  }
  public String getRuntimeClassName() {
    return this.runtimeClassName;
  }
  public A withRuntimeClassName(String runtimeClassName) {
    this.runtimeClassName=runtimeClassName; return (A) this;
  }
  public Boolean hasRuntimeClassName() {
    return this.runtimeClassName != null;
  }
  public String getSchedulerName() {
    return this.schedulerName;
  }
  public A withSchedulerName(String schedulerName) {
    this.schedulerName=schedulerName; return (A) this;
  }
  public Boolean hasSchedulerName() {
    return this.schedulerName != null;
  }
  public PodSecurityContext getSecurityContext() {
    return this.securityContext;
  }
  public A withSecurityContext(PodSecurityContext securityContext) {
    this.securityContext=securityContext; return (A) this;
  }
  public Boolean hasSecurityContext() {
    return this.securityContext != null;
  }
  public String getServiceAccount() {
    return this.serviceAccount;
  }
  public A withServiceAccount(String serviceAccount) {
    this.serviceAccount=serviceAccount; return (A) this;
  }
  public Boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  public Boolean getSetHostnameAsFQDN() {
    return this.setHostnameAsFQDN;
  }
  public A withSetHostnameAsFQDN(Boolean setHostnameAsFQDN) {
    this.setHostnameAsFQDN=setHostnameAsFQDN; return (A) this;
  }
  public Boolean hasSetHostnameAsFQDN() {
    return this.setHostnameAsFQDN != null;
  }
  public Boolean getShareProcessNamespace() {
    return this.shareProcessNamespace;
  }
  public A withShareProcessNamespace(Boolean shareProcessNamespace) {
    this.shareProcessNamespace=shareProcessNamespace; return (A) this;
  }
  public Boolean hasShareProcessNamespace() {
    return this.shareProcessNamespace != null;
  }
  public String getSubdomain() {
    return this.subdomain;
  }
  public A withSubdomain(String subdomain) {
    this.subdomain=subdomain; return (A) this;
  }
  public Boolean hasSubdomain() {
    return this.subdomain != null;
  }
  public Long getTerminationGracePeriodSeconds() {
    return this.terminationGracePeriodSeconds;
  }
  public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
    this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (A) this;
  }
  public Boolean hasTerminationGracePeriodSeconds() {
    return this.terminationGracePeriodSeconds != null;
  }
  public Long getTimeoutSeconds() {
    return this.timeoutSeconds;
  }
  public A withTimeoutSeconds(Long timeoutSeconds) {
    this.timeoutSeconds=timeoutSeconds; return (A) this;
  }
  public Boolean hasTimeoutSeconds() {
    return this.timeoutSeconds != null;
  }
  public A addToTolerations(Integer index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  public A setToTolerations(Integer index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public A removeAllFromTolerations(Collection<Toleration> items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public List<Toleration> getTolerations() {
    return this.tolerations;
  }
  public Toleration getToleration(Integer index) {
    return this.tolerations.get(index);
  }
  public Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  public Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(List<Toleration> tolerations) {
    if (tolerations != null) {this.tolerations = new ArrayList(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear();}
    if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public Boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public A addToTopologySpreadConstraints(Integer index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    this.topologySpreadConstraints.add(index, item);
    return (A)this;
  }
  public A setToTopologySpreadConstraints(Integer index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    this.topologySpreadConstraints.set(index, item); return (A)this;
  }
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    for (TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
  }
  public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    for (TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
  }
  public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
    return this.topologySpreadConstraints;
  }
  public TopologySpreadConstraint getTopologySpreadConstraint(Integer index) {
    return this.topologySpreadConstraints.get(index);
  }
  public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(0);
  }
  public TopologySpreadConstraint getLastTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(topologySpreadConstraints.size() - 1);
  }
  public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
    for (TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
    for (TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
    if (topologySpreadConstraints != null) {this.topologySpreadConstraints = new ArrayList(); for (TopologySpreadConstraint item : topologySpreadConstraints){this.addToTopologySpreadConstraints(item);}} else { this.topologySpreadConstraints = null;} return (A) this;
  }
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints) {
    if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.clear();}
    if (topologySpreadConstraints != null) {for (TopologySpreadConstraint item :topologySpreadConstraints){ this.addToTopologySpreadConstraints(item);}} return (A) this;
  }
  public Boolean hasTopologySpreadConstraints() {
    return topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty();
  }
  public A addToVolumes(Integer index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
  }
  public A setToVolumes(Integer index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    VolumeBuilder builder = new VolumeBuilder(item);
    if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
    if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
     return (A)this;
  }
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A addAllToVolumes(Collection<Volume> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumes(Collection<Volume> items) {
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
    if (volumes == null) return (A) this;
    final Iterator<VolumeBuilder> each = volumes.iterator();
    final List visitables = _visitables.get("volumes");
    while (each.hasNext()) {
      VolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Volume> getVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public List<Volume> buildVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public Volume buildVolume(Integer index) {
    return this.volumes.get(index).build();
  }
  public Volume buildFirstVolume() {
    return this.volumes.get(0).build();
  }
  public Volume buildLastVolume() {
    return this.volumes.get(volumes.size() - 1).build();
  }
  public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
    for (VolumeBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
    for (VolumeBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(List<Volume> volumes) {
    if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
    if (volumes != null) {this.volumes = new ArrayList(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes) {
    if (this.volumes != null) {this.volumes.clear();}
    if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public RevisionSpecFluent.VolumesNested<A> addNewVolume() {
    return new RevisionSpecFluentImpl.VolumesNestedImpl();
  }
  public RevisionSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
    return new RevisionSpecFluentImpl.VolumesNestedImpl(-1, item);
  }
  public RevisionSpecFluent.VolumesNested<A> setNewVolumeLike(Integer index,Volume item) {
    return new RevisionSpecFluentImpl.VolumesNestedImpl(index, item);
  }
  public RevisionSpecFluent.VolumesNested<A> editVolume(Integer index) {
    if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public RevisionSpecFluent.VolumesNested<A> editFirstVolume() {
    if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
    return setNewVolumeLike(0, buildVolume(0));
  }
  public RevisionSpecFluent.VolumesNested<A> editLastVolume() {
    int index = volumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public RevisionSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumes.size();i++) { 
    if (predicate.test(volumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RevisionSpecFluentImpl that = (RevisionSpecFluentImpl) o;
    if (activeDeadlineSeconds != null ? !activeDeadlineSeconds.equals(that.activeDeadlineSeconds) :that.activeDeadlineSeconds != null) return false;
    if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
    if (automountServiceAccountToken != null ? !automountServiceAccountToken.equals(that.automountServiceAccountToken) :that.automountServiceAccountToken != null) return false;
    if (containerConcurrency != null ? !containerConcurrency.equals(that.containerConcurrency) :that.containerConcurrency != null) return false;
    if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
    if (dnsConfig != null ? !dnsConfig.equals(that.dnsConfig) :that.dnsConfig != null) return false;
    if (dnsPolicy != null ? !dnsPolicy.equals(that.dnsPolicy) :that.dnsPolicy != null) return false;
    if (enableServiceLinks != null ? !enableServiceLinks.equals(that.enableServiceLinks) :that.enableServiceLinks != null) return false;
    if (ephemeralContainers != null ? !ephemeralContainers.equals(that.ephemeralContainers) :that.ephemeralContainers != null) return false;
    if (hostAliases != null ? !hostAliases.equals(that.hostAliases) :that.hostAliases != null) return false;
    if (hostIPC != null ? !hostIPC.equals(that.hostIPC) :that.hostIPC != null) return false;
    if (hostNetwork != null ? !hostNetwork.equals(that.hostNetwork) :that.hostNetwork != null) return false;
    if (hostPID != null ? !hostPID.equals(that.hostPID) :that.hostPID != null) return false;
    if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
    if (idleTimeoutSeconds != null ? !idleTimeoutSeconds.equals(that.idleTimeoutSeconds) :that.idleTimeoutSeconds != null) return false;
    if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
    if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
    if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
    if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
    if (os != null ? !os.equals(that.os) :that.os != null) return false;
    if (overhead != null ? !overhead.equals(that.overhead) :that.overhead != null) return false;
    if (preemptionPolicy != null ? !preemptionPolicy.equals(that.preemptionPolicy) :that.preemptionPolicy != null) return false;
    if (priority != null ? !priority.equals(that.priority) :that.priority != null) return false;
    if (priorityClassName != null ? !priorityClassName.equals(that.priorityClassName) :that.priorityClassName != null) return false;
    if (readinessGates != null ? !readinessGates.equals(that.readinessGates) :that.readinessGates != null) return false;
    if (responseStartTimeoutSeconds != null ? !responseStartTimeoutSeconds.equals(that.responseStartTimeoutSeconds) :that.responseStartTimeoutSeconds != null) return false;
    if (restartPolicy != null ? !restartPolicy.equals(that.restartPolicy) :that.restartPolicy != null) return false;
    if (runtimeClassName != null ? !runtimeClassName.equals(that.runtimeClassName) :that.runtimeClassName != null) return false;
    if (schedulerName != null ? !schedulerName.equals(that.schedulerName) :that.schedulerName != null) return false;
    if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
    if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
    if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
    if (setHostnameAsFQDN != null ? !setHostnameAsFQDN.equals(that.setHostnameAsFQDN) :that.setHostnameAsFQDN != null) return false;
    if (shareProcessNamespace != null ? !shareProcessNamespace.equals(that.shareProcessNamespace) :that.shareProcessNamespace != null) return false;
    if (subdomain != null ? !subdomain.equals(that.subdomain) :that.subdomain != null) return false;
    if (terminationGracePeriodSeconds != null ? !terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) :that.terminationGracePeriodSeconds != null) return false;
    if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
    if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
    if (topologySpreadConstraints != null ? !topologySpreadConstraints.equals(that.topologySpreadConstraints) :that.topologySpreadConstraints != null) return false;
    if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(activeDeadlineSeconds,  affinity,  automountServiceAccountToken,  containerConcurrency,  containers,  dnsConfig,  dnsPolicy,  enableServiceLinks,  ephemeralContainers,  hostAliases,  hostIPC,  hostNetwork,  hostPID,  hostname,  idleTimeoutSeconds,  imagePullSecrets,  initContainers,  nodeName,  nodeSelector,  os,  overhead,  preemptionPolicy,  priority,  priorityClassName,  readinessGates,  responseStartTimeoutSeconds,  restartPolicy,  runtimeClassName,  schedulerName,  securityContext,  serviceAccount,  serviceAccountName,  setHostnameAsFQDN,  shareProcessNamespace,  subdomain,  terminationGracePeriodSeconds,  timeoutSeconds,  tolerations,  topologySpreadConstraints,  volumes,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (activeDeadlineSeconds != null) { sb.append("activeDeadlineSeconds:"); sb.append(activeDeadlineSeconds + ","); }
    if (affinity != null) { sb.append("affinity:"); sb.append(affinity + ","); }
    if (automountServiceAccountToken != null) { sb.append("automountServiceAccountToken:"); sb.append(automountServiceAccountToken + ","); }
    if (containerConcurrency != null) { sb.append("containerConcurrency:"); sb.append(containerConcurrency + ","); }
    if (containers != null && !containers.isEmpty()) { sb.append("containers:"); sb.append(containers + ","); }
    if (dnsConfig != null) { sb.append("dnsConfig:"); sb.append(dnsConfig + ","); }
    if (dnsPolicy != null) { sb.append("dnsPolicy:"); sb.append(dnsPolicy + ","); }
    if (enableServiceLinks != null) { sb.append("enableServiceLinks:"); sb.append(enableServiceLinks + ","); }
    if (ephemeralContainers != null && !ephemeralContainers.isEmpty()) { sb.append("ephemeralContainers:"); sb.append(ephemeralContainers + ","); }
    if (hostAliases != null && !hostAliases.isEmpty()) { sb.append("hostAliases:"); sb.append(hostAliases + ","); }
    if (hostIPC != null) { sb.append("hostIPC:"); sb.append(hostIPC + ","); }
    if (hostNetwork != null) { sb.append("hostNetwork:"); sb.append(hostNetwork + ","); }
    if (hostPID != null) { sb.append("hostPID:"); sb.append(hostPID + ","); }
    if (hostname != null) { sb.append("hostname:"); sb.append(hostname + ","); }
    if (idleTimeoutSeconds != null) { sb.append("idleTimeoutSeconds:"); sb.append(idleTimeoutSeconds + ","); }
    if (imagePullSecrets != null && !imagePullSecrets.isEmpty()) { sb.append("imagePullSecrets:"); sb.append(imagePullSecrets + ","); }
    if (initContainers != null && !initContainers.isEmpty()) { sb.append("initContainers:"); sb.append(initContainers + ","); }
    if (nodeName != null) { sb.append("nodeName:"); sb.append(nodeName + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (os != null) { sb.append("os:"); sb.append(os + ","); }
    if (overhead != null && !overhead.isEmpty()) { sb.append("overhead:"); sb.append(overhead + ","); }
    if (preemptionPolicy != null) { sb.append("preemptionPolicy:"); sb.append(preemptionPolicy + ","); }
    if (priority != null) { sb.append("priority:"); sb.append(priority + ","); }
    if (priorityClassName != null) { sb.append("priorityClassName:"); sb.append(priorityClassName + ","); }
    if (readinessGates != null && !readinessGates.isEmpty()) { sb.append("readinessGates:"); sb.append(readinessGates + ","); }
    if (responseStartTimeoutSeconds != null) { sb.append("responseStartTimeoutSeconds:"); sb.append(responseStartTimeoutSeconds + ","); }
    if (restartPolicy != null) { sb.append("restartPolicy:"); sb.append(restartPolicy + ","); }
    if (runtimeClassName != null) { sb.append("runtimeClassName:"); sb.append(runtimeClassName + ","); }
    if (schedulerName != null) { sb.append("schedulerName:"); sb.append(schedulerName + ","); }
    if (securityContext != null) { sb.append("securityContext:"); sb.append(securityContext + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (setHostnameAsFQDN != null) { sb.append("setHostnameAsFQDN:"); sb.append(setHostnameAsFQDN + ","); }
    if (shareProcessNamespace != null) { sb.append("shareProcessNamespace:"); sb.append(shareProcessNamespace + ","); }
    if (subdomain != null) { sb.append("subdomain:"); sb.append(subdomain + ","); }
    if (terminationGracePeriodSeconds != null) { sb.append("terminationGracePeriodSeconds:"); sb.append(terminationGracePeriodSeconds + ","); }
    if (timeoutSeconds != null) { sb.append("timeoutSeconds:"); sb.append(timeoutSeconds + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations + ","); }
    if (topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty()) { sb.append("topologySpreadConstraints:"); sb.append(topologySpreadConstraints + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes); }
    sb.append("}");
    return sb.toString();
  }
  public A withAutomountServiceAccountToken() {
    return withAutomountServiceAccountToken(true);
  }
  public A withEnableServiceLinks() {
    return withEnableServiceLinks(true);
  }
  public A withHostIPC() {
    return withHostIPC(true);
  }
  public A withHostNetwork() {
    return withHostNetwork(true);
  }
  public A withHostPID() {
    return withHostPID(true);
  }
  public A withSetHostnameAsFQDN() {
    return withSetHostnameAsFQDN(true);
  }
  public A withShareProcessNamespace() {
    return withShareProcessNamespace(true);
  }
  class ContainersNestedImpl<N> extends ContainerFluentImpl<RevisionSpecFluent.ContainersNested<N>> implements RevisionSpecFluent.ContainersNested<N>,Nested<N>{
    ContainersNestedImpl(Integer index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    ContainersNestedImpl() {
      this.index = -1;
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    Integer index;
    public N and() {
      return (N) RevisionSpecFluentImpl.this.setToContainers(index,builder.build());
    }
    public N endContainer() {
      return and();
    }
    
  }
  class ImagePullSecretsNestedImpl<N> extends LocalObjectReferenceFluentImpl<RevisionSpecFluent.ImagePullSecretsNested<N>> implements RevisionSpecFluent.ImagePullSecretsNested<N>,Nested<N>{
    ImagePullSecretsNestedImpl(Integer index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    ImagePullSecretsNestedImpl() {
      this.index = -1;
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) RevisionSpecFluentImpl.this.setToImagePullSecrets(index,builder.build());
    }
    public N endImagePullSecret() {
      return and();
    }
    
  }
  class InitContainersNestedImpl<N> extends ContainerFluentImpl<RevisionSpecFluent.InitContainersNested<N>> implements RevisionSpecFluent.InitContainersNested<N>,Nested<N>{
    InitContainersNestedImpl(Integer index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    InitContainersNestedImpl() {
      this.index = -1;
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    Integer index;
    public N and() {
      return (N) RevisionSpecFluentImpl.this.setToInitContainers(index,builder.build());
    }
    public N endInitContainer() {
      return and();
    }
    
  }
  class VolumesNestedImpl<N> extends VolumeFluentImpl<RevisionSpecFluent.VolumesNested<N>> implements RevisionSpecFluent.VolumesNested<N>,Nested<N>{
    VolumesNestedImpl(Integer index,Volume item) {
      this.index = index;
      this.builder = new VolumeBuilder(this, item);
    }
    VolumesNestedImpl() {
      this.index = -1;
      this.builder = new VolumeBuilder(this);
    }
    VolumeBuilder builder;
    Integer index;
    public N and() {
      return (N) RevisionSpecFluentImpl.this.setToVolumes(index,builder.build());
    }
    public N endVolume() {
      return and();
    }
    
  }
  
}