package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import java.lang.Integer;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SubscriptionStatusFluentImpl<A extends SubscriptionStatusFluent<A>> extends BaseFluent<A> implements SubscriptionStatusFluent<A>{
  public SubscriptionStatusFluentImpl() {
  }
  public SubscriptionStatusFluentImpl(SubscriptionStatus instance) {
    this.withAnnotations(instance.getAnnotations()); 
    this.withConditions(instance.getConditions()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withPhysicalSubscription(instance.getPhysicalSubscription()); 
  }
  private Map<String,String> annotations;
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private Long observedGeneration;
  private SubscriptionStatusPhysicalSubscriptionBuilder physicalSubscription;
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  public A addToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Condition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<Condition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public Condition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public SubscriptionStatusFluent.ConditionsNested<A> addNewCondition() {
    return new SubscriptionStatusFluentImpl.ConditionsNestedImpl();
  }
  public SubscriptionStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
    return new SubscriptionStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public SubscriptionStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,Condition item) {
    return new SubscriptionStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public SubscriptionStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public SubscriptionStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public SubscriptionStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public SubscriptionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPhysicalSubscription instead.
   * @return The buildable object.
   */
  @Deprecated
  public SubscriptionStatusPhysicalSubscription getPhysicalSubscription() {
    return this.physicalSubscription!=null ?this.physicalSubscription.build():null;
  }
  public SubscriptionStatusPhysicalSubscription buildPhysicalSubscription() {
    return this.physicalSubscription!=null ?this.physicalSubscription.build():null;
  }
  public A withPhysicalSubscription(SubscriptionStatusPhysicalSubscription physicalSubscription) {
    _visitables.get("physicalSubscription").remove(this.physicalSubscription);
    if (physicalSubscription!=null){ this.physicalSubscription= new SubscriptionStatusPhysicalSubscriptionBuilder(physicalSubscription); _visitables.get("physicalSubscription").add(this.physicalSubscription);} else { this.physicalSubscription = null; _visitables.get("physicalSubscription").remove(this.physicalSubscription); } return (A) this;
  }
  public Boolean hasPhysicalSubscription() {
    return this.physicalSubscription != null;
  }
  public A withNewPhysicalSubscription(String deadLetterSinkUri,String replyUri,String subscriberUri) {
    return (A)withPhysicalSubscription(new SubscriptionStatusPhysicalSubscription(deadLetterSinkUri, replyUri, subscriberUri));
  }
  public SubscriptionStatusFluent.PhysicalSubscriptionNested<A> withNewPhysicalSubscription() {
    return new SubscriptionStatusFluentImpl.PhysicalSubscriptionNestedImpl();
  }
  public SubscriptionStatusFluent.PhysicalSubscriptionNested<A> withNewPhysicalSubscriptionLike(SubscriptionStatusPhysicalSubscription item) {
    return new SubscriptionStatusFluentImpl.PhysicalSubscriptionNestedImpl(item);
  }
  public SubscriptionStatusFluent.PhysicalSubscriptionNested<A> editPhysicalSubscription() {
    return withNewPhysicalSubscriptionLike(getPhysicalSubscription());
  }
  public SubscriptionStatusFluent.PhysicalSubscriptionNested<A> editOrNewPhysicalSubscription() {
    return withNewPhysicalSubscriptionLike(getPhysicalSubscription() != null ? getPhysicalSubscription(): new SubscriptionStatusPhysicalSubscriptionBuilder().build());
  }
  public SubscriptionStatusFluent.PhysicalSubscriptionNested<A> editOrNewPhysicalSubscriptionLike(SubscriptionStatusPhysicalSubscription item) {
    return withNewPhysicalSubscriptionLike(getPhysicalSubscription() != null ? getPhysicalSubscription(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SubscriptionStatusFluentImpl that = (SubscriptionStatusFluentImpl) o;
    if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (physicalSubscription != null ? !physicalSubscription.equals(that.physicalSubscription) :that.physicalSubscription != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(annotations,  conditions,  observedGeneration,  physicalSubscription,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (physicalSubscription != null) { sb.append("physicalSubscription:"); sb.append(physicalSubscription); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends ConditionFluentImpl<SubscriptionStatusFluent.ConditionsNested<N>> implements SubscriptionStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ConditionBuilder(this);
    }
    ConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) SubscriptionStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class PhysicalSubscriptionNestedImpl<N> extends SubscriptionStatusPhysicalSubscriptionFluentImpl<SubscriptionStatusFluent.PhysicalSubscriptionNested<N>> implements SubscriptionStatusFluent.PhysicalSubscriptionNested<N>,Nested<N>{
    PhysicalSubscriptionNestedImpl(SubscriptionStatusPhysicalSubscription item) {
      this.builder = new SubscriptionStatusPhysicalSubscriptionBuilder(this, item);
    }
    PhysicalSubscriptionNestedImpl() {
      this.builder = new SubscriptionStatusPhysicalSubscriptionBuilder(this);
    }
    SubscriptionStatusPhysicalSubscriptionBuilder builder;
    public N and() {
      return (N) SubscriptionStatusFluentImpl.this.withPhysicalSubscription(builder.build());
    }
    public N endPhysicalSubscription() {
      return and();
    }
    
  }
  
}