package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReference;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusFluentImpl;
import java.lang.Deprecated;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluentImpl;
import io.fabric8.knative.internal.pkg.apis.Condition;
import java.lang.Integer;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class InMemoryChannelStatusFluentImpl<A extends InMemoryChannelStatusFluent<A>> extends BaseFluent<A> implements InMemoryChannelStatusFluent<A>{
  public InMemoryChannelStatusFluentImpl() {
  }
  public InMemoryChannelStatusFluentImpl(InMemoryChannelStatus instance) {
    this.withAddress(instance.getAddress()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withConditions(instance.getConditions()); 
    this.withDeadLetterChannel(instance.getDeadLetterChannel()); 
    this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withSubscribers(instance.getSubscribers()); 
  }
  private AddressableBuilder address;
  private Map<String,String> annotations;
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private KReferenceBuilder deadLetterChannel;
  private String deadLetterSinkUri;
  private Long observedGeneration;
  private ArrayList<SubscriberStatusBuilder> subscribers = new ArrayList<SubscriberStatusBuilder>();
  
  /**
   * This method has been deprecated, please use method buildAddress instead.
   * @return The buildable object.
   */
  @Deprecated
  public Addressable getAddress() {
    return this.address!=null ?this.address.build():null;
  }
  public Addressable buildAddress() {
    return this.address!=null ?this.address.build():null;
  }
  public A withAddress(Addressable address) {
    _visitables.get("address").remove(this.address);
    if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} else { this.address = null; _visitables.get("address").remove(this.address); } return (A) this;
  }
  public Boolean hasAddress() {
    return this.address != null;
  }
  public A withNewAddress(String url) {
    return (A)withAddress(new Addressable(url));
  }
  public InMemoryChannelStatusFluent.AddressNested<A> withNewAddress() {
    return new InMemoryChannelStatusFluentImpl.AddressNestedImpl();
  }
  public InMemoryChannelStatusFluent.AddressNested<A> withNewAddressLike(Addressable item) {
    return new InMemoryChannelStatusFluentImpl.AddressNestedImpl(item);
  }
  public InMemoryChannelStatusFluent.AddressNested<A> editAddress() {
    return withNewAddressLike(getAddress());
  }
  public InMemoryChannelStatusFluent.AddressNested<A> editOrNewAddress() {
    return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
  }
  public InMemoryChannelStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item) {
    return withNewAddressLike(getAddress() != null ? getAddress(): item);
  }
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  public A addToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Condition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<Condition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public Condition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public InMemoryChannelStatusFluent.ConditionsNested<A> addNewCondition() {
    return new InMemoryChannelStatusFluentImpl.ConditionsNestedImpl();
  }
  public InMemoryChannelStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
    return new InMemoryChannelStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public InMemoryChannelStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,Condition item) {
    return new InMemoryChannelStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public InMemoryChannelStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public InMemoryChannelStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public InMemoryChannelStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public InMemoryChannelStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildDeadLetterChannel instead.
   * @return The buildable object.
   */
  @Deprecated
  public KReference getDeadLetterChannel() {
    return this.deadLetterChannel!=null ?this.deadLetterChannel.build():null;
  }
  public KReference buildDeadLetterChannel() {
    return this.deadLetterChannel!=null ?this.deadLetterChannel.build():null;
  }
  public A withDeadLetterChannel(KReference deadLetterChannel) {
    _visitables.get("deadLetterChannel").remove(this.deadLetterChannel);
    if (deadLetterChannel!=null){ this.deadLetterChannel= new KReferenceBuilder(deadLetterChannel); _visitables.get("deadLetterChannel").add(this.deadLetterChannel);} else { this.deadLetterChannel = null; _visitables.get("deadLetterChannel").remove(this.deadLetterChannel); } return (A) this;
  }
  public Boolean hasDeadLetterChannel() {
    return this.deadLetterChannel != null;
  }
  public A withNewDeadLetterChannel(String apiVersion,String group,String kind,String name,String namespace) {
    return (A)withDeadLetterChannel(new KReference(apiVersion, group, kind, name, namespace));
  }
  public InMemoryChannelStatusFluent.DeadLetterChannelNested<A> withNewDeadLetterChannel() {
    return new InMemoryChannelStatusFluentImpl.DeadLetterChannelNestedImpl();
  }
  public InMemoryChannelStatusFluent.DeadLetterChannelNested<A> withNewDeadLetterChannelLike(KReference item) {
    return new InMemoryChannelStatusFluentImpl.DeadLetterChannelNestedImpl(item);
  }
  public InMemoryChannelStatusFluent.DeadLetterChannelNested<A> editDeadLetterChannel() {
    return withNewDeadLetterChannelLike(getDeadLetterChannel());
  }
  public InMemoryChannelStatusFluent.DeadLetterChannelNested<A> editOrNewDeadLetterChannel() {
    return withNewDeadLetterChannelLike(getDeadLetterChannel() != null ? getDeadLetterChannel(): new KReferenceBuilder().build());
  }
  public InMemoryChannelStatusFluent.DeadLetterChannelNested<A> editOrNewDeadLetterChannelLike(KReference item) {
    return withNewDeadLetterChannelLike(getDeadLetterChannel() != null ? getDeadLetterChannel(): item);
  }
  public String getDeadLetterSinkUri() {
    return this.deadLetterSinkUri;
  }
  public A withDeadLetterSinkUri(String deadLetterSinkUri) {
    this.deadLetterSinkUri=deadLetterSinkUri; return (A) this;
  }
  public Boolean hasDeadLetterSinkUri() {
    return this.deadLetterSinkUri != null;
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public A addToSubscribers(Integer index,SubscriberStatus item) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
    SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").add(index >= 0 ? index : _visitables.get("subscribers").size(), builder);this.subscribers.add(index >= 0 ? index : subscribers.size(), builder); return (A)this;
  }
  public A setToSubscribers(Integer index,SubscriberStatus item) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
    SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("subscribers").size()) { _visitables.get("subscribers").add(builder); } else { _visitables.get("subscribers").set(index, builder);}
    if (index < 0 || index >= subscribers.size()) { subscribers.add(builder); } else { subscribers.set(index, builder);}
     return (A)this;
  }
  public A addToSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus... items) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
    for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
  }
  public A addAllToSubscribers(Collection<SubscriberStatus> items) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
    for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
  }
  public A removeFromSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus... items) {
    for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
  }
  public A removeAllFromSubscribers(Collection<SubscriberStatus> items) {
    for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSubscribers(Predicate<SubscriberStatusBuilder> predicate) {
    if (subscribers == null) return (A) this;
    final Iterator<SubscriberStatusBuilder> each = subscribers.iterator();
    final List visitables = _visitables.get("subscribers");
    while (each.hasNext()) {
      SubscriberStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSubscribers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SubscriberStatus> getSubscribers() {
    return subscribers != null ? build(subscribers) : null;
  }
  public List<SubscriberStatus> buildSubscribers() {
    return subscribers != null ? build(subscribers) : null;
  }
  public SubscriberStatus buildSubscriber(Integer index) {
    return this.subscribers.get(index).build();
  }
  public SubscriberStatus buildFirstSubscriber() {
    return this.subscribers.get(0).build();
  }
  public SubscriberStatus buildLastSubscriber() {
    return this.subscribers.get(subscribers.size() - 1).build();
  }
  public SubscriberStatus buildMatchingSubscriber(Predicate<SubscriberStatusBuilder> predicate) {
    for (SubscriberStatusBuilder item: subscribers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSubscriber(Predicate<SubscriberStatusBuilder> predicate) {
    for (SubscriberStatusBuilder item: subscribers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubscribers(List<SubscriberStatus> subscribers) {
    if (this.subscribers != null) { _visitables.get("subscribers").removeAll(this.subscribers);}
    if (subscribers != null) {this.subscribers = new ArrayList(); for (SubscriberStatus item : subscribers){this.addToSubscribers(item);}} else { this.subscribers = null;} return (A) this;
  }
  public A withSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus... subscribers) {
    if (this.subscribers != null) {this.subscribers.clear();}
    if (subscribers != null) {for (SubscriberStatus item :subscribers){ this.addToSubscribers(item);}} return (A) this;
  }
  public Boolean hasSubscribers() {
    return subscribers != null && !subscribers.isEmpty();
  }
  public A addNewSubscriber(String message,Long observedGeneration,String ready,String uid) {
    return (A)addToSubscribers(new SubscriberStatus(message, observedGeneration, ready, uid));
  }
  public InMemoryChannelStatusFluent.SubscribersNested<A> addNewSubscriber() {
    return new InMemoryChannelStatusFluentImpl.SubscribersNestedImpl();
  }
  public InMemoryChannelStatusFluent.SubscribersNested<A> addNewSubscriberLike(SubscriberStatus item) {
    return new InMemoryChannelStatusFluentImpl.SubscribersNestedImpl(-1, item);
  }
  public InMemoryChannelStatusFluent.SubscribersNested<A> setNewSubscriberLike(Integer index,SubscriberStatus item) {
    return new InMemoryChannelStatusFluentImpl.SubscribersNestedImpl(index, item);
  }
  public InMemoryChannelStatusFluent.SubscribersNested<A> editSubscriber(Integer index) {
    if (subscribers.size() <= index) throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  public InMemoryChannelStatusFluent.SubscribersNested<A> editFirstSubscriber() {
    if (subscribers.size() == 0) throw new RuntimeException("Can't edit first subscribers. The list is empty.");
    return setNewSubscriberLike(0, buildSubscriber(0));
  }
  public InMemoryChannelStatusFluent.SubscribersNested<A> editLastSubscriber() {
    int index = subscribers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subscribers. The list is empty.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  public InMemoryChannelStatusFluent.SubscribersNested<A> editMatchingSubscriber(Predicate<SubscriberStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subscribers.size();i++) { 
    if (predicate.test(subscribers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subscribers. No match found.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InMemoryChannelStatusFluentImpl that = (InMemoryChannelStatusFluentImpl) o;
    if (address != null ? !address.equals(that.address) :that.address != null) return false;
    if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (deadLetterChannel != null ? !deadLetterChannel.equals(that.deadLetterChannel) :that.deadLetterChannel != null) return false;
    if (deadLetterSinkUri != null ? !deadLetterSinkUri.equals(that.deadLetterSinkUri) :that.deadLetterSinkUri != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (subscribers != null ? !subscribers.equals(that.subscribers) :that.subscribers != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(address,  annotations,  conditions,  deadLetterChannel,  deadLetterSinkUri,  observedGeneration,  subscribers,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (address != null) { sb.append("address:"); sb.append(address + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (deadLetterChannel != null) { sb.append("deadLetterChannel:"); sb.append(deadLetterChannel + ","); }
    if (deadLetterSinkUri != null) { sb.append("deadLetterSinkUri:"); sb.append(deadLetterSinkUri + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (subscribers != null && !subscribers.isEmpty()) { sb.append("subscribers:"); sb.append(subscribers); }
    sb.append("}");
    return sb.toString();
  }
  class AddressNestedImpl<N> extends AddressableFluentImpl<InMemoryChannelStatusFluent.AddressNested<N>> implements InMemoryChannelStatusFluent.AddressNested<N>,Nested<N>{
    AddressNestedImpl(Addressable item) {
      this.builder = new AddressableBuilder(this, item);
    }
    AddressNestedImpl() {
      this.builder = new AddressableBuilder(this);
    }
    AddressableBuilder builder;
    public N and() {
      return (N) InMemoryChannelStatusFluentImpl.this.withAddress(builder.build());
    }
    public N endAddress() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends ConditionFluentImpl<InMemoryChannelStatusFluent.ConditionsNested<N>> implements InMemoryChannelStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ConditionBuilder(this);
    }
    ConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) InMemoryChannelStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class DeadLetterChannelNestedImpl<N> extends KReferenceFluentImpl<InMemoryChannelStatusFluent.DeadLetterChannelNested<N>> implements InMemoryChannelStatusFluent.DeadLetterChannelNested<N>,Nested<N>{
    DeadLetterChannelNestedImpl(KReference item) {
      this.builder = new KReferenceBuilder(this, item);
    }
    DeadLetterChannelNestedImpl() {
      this.builder = new KReferenceBuilder(this);
    }
    KReferenceBuilder builder;
    public N and() {
      return (N) InMemoryChannelStatusFluentImpl.this.withDeadLetterChannel(builder.build());
    }
    public N endDeadLetterChannel() {
      return and();
    }
    
  }
  class SubscribersNestedImpl<N> extends SubscriberStatusFluentImpl<InMemoryChannelStatusFluent.SubscribersNested<N>> implements InMemoryChannelStatusFluent.SubscribersNested<N>,Nested<N>{
    SubscribersNestedImpl(Integer index,SubscriberStatus item) {
      this.index = index;
      this.builder = new SubscriberStatusBuilder(this, item);
    }
    SubscribersNestedImpl() {
      this.index = -1;
      this.builder = new SubscriberStatusBuilder(this);
    }
    SubscriberStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) InMemoryChannelStatusFluentImpl.this.setToSubscribers(index,builder.build());
    }
    public N endSubscriber() {
      return and();
    }
    
  }
  
}