package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SequenceBuilder extends SequenceFluentImpl<SequenceBuilder> implements VisitableBuilder<Sequence,SequenceBuilder>{
  public SequenceBuilder() {
    this(false);
  }
  public SequenceBuilder(Boolean validationEnabled) {
    this(new Sequence(), validationEnabled);
  }
  public SequenceBuilder(SequenceFluent<?> fluent) {
    this(fluent, false);
  }
  public SequenceBuilder(SequenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Sequence(), validationEnabled);
  }
  public SequenceBuilder(SequenceFluent<?> fluent,Sequence instance) {
    this(fluent, instance, false);
  }
  public SequenceBuilder(SequenceFluent<?> fluent,Sequence instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public SequenceBuilder(Sequence instance) {
    this(instance,false);
  }
  public SequenceBuilder(Sequence instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  SequenceFluent<?> fluent;
  Boolean validationEnabled;
  public Sequence build() {
    Sequence buildable = new Sequence(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}