package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaNetSpecBuilder extends KafkaNetSpecFluentImpl<KafkaNetSpecBuilder> implements VisitableBuilder<KafkaNetSpec,KafkaNetSpecBuilder>{
  public KafkaNetSpecBuilder() {
    this(false);
  }
  public KafkaNetSpecBuilder(Boolean validationEnabled) {
    this(new KafkaNetSpec(), validationEnabled);
  }
  public KafkaNetSpecBuilder(KafkaNetSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaNetSpecBuilder(KafkaNetSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaNetSpec(), validationEnabled);
  }
  public KafkaNetSpecBuilder(KafkaNetSpecFluent<?> fluent,KafkaNetSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaNetSpecBuilder(KafkaNetSpecFluent<?> fluent,KafkaNetSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSasl(instance.getSasl()); 
    fluent.withTls(instance.getTls()); 
    this.validationEnabled = validationEnabled; 
  }
  public KafkaNetSpecBuilder(KafkaNetSpec instance) {
    this(instance,false);
  }
  public KafkaNetSpecBuilder(KafkaNetSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withSasl(instance.getSasl()); 
    this.withTls(instance.getTls()); 
    this.validationEnabled = validationEnabled; 
  }
  KafkaNetSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaNetSpec build() {
    KafkaNetSpec buildable = new KafkaNetSpec(fluent.getSasl(),fluent.getTls());
    return buildable;
  }
  
}