package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ParallelListBuilder extends io.fabric8.knative.flows.v1.ParallelListFluentImpl<io.fabric8.knative.flows.v1.ParallelListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.flows.v1.ParallelList,io.fabric8.knative.flows.v1.ParallelListBuilder> {

    io.fabric8.knative.flows.v1.ParallelListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ParallelListBuilder() {
        this(true);
    }

    public ParallelListBuilder(java.lang.Boolean validationEnabled) {
        this(new ParallelList(), validationEnabled);
    }

    public ParallelListBuilder(io.fabric8.knative.flows.v1.ParallelListFluent<?> fluent) {
        this(fluent, true);
    }

    public ParallelListBuilder(io.fabric8.knative.flows.v1.ParallelListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ParallelList(), validationEnabled);
    }

    public ParallelListBuilder(io.fabric8.knative.flows.v1.ParallelListFluent<?> fluent,io.fabric8.knative.flows.v1.ParallelList instance) {
        this(fluent, instance, true);
    }

    public ParallelListBuilder(io.fabric8.knative.flows.v1.ParallelListFluent<?> fluent,io.fabric8.knative.flows.v1.ParallelList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ParallelListBuilder(io.fabric8.knative.flows.v1.ParallelList instance) {
        this(instance,true);
    }

    public ParallelListBuilder(io.fabric8.knative.flows.v1.ParallelList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.flows.v1.EditableParallelList build() {
        EditableParallelList buildable = new EditableParallelList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ParallelListBuilder that = (ParallelListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
