package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

public class KafkaSourceSpecFluentImpl<A extends io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent<A> {

    private java.util.List<java.lang.String> bootstrapServers;
    private io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder ceOverrides;
    private java.lang.String consumerGroup;
    private io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecBuilder net;
    private io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder sink;
    private java.util.List<java.lang.String> topics;

    public KafkaSourceSpecFluentImpl() {
    }

    public KafkaSourceSpecFluentImpl(io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpec instance) {
        this.withBootstrapServers(instance.getBootstrapServers()); 
        this.withCeOverrides(instance.getCeOverrides()); 
        this.withConsumerGroup(instance.getConsumerGroup()); 
        this.withNet(instance.getNet()); 
        this.withSink(instance.getSink()); 
        this.withTopics(instance.getTopics()); 
    }

    public A addToBootstrapServers(int index,java.lang.String item) {
        if (this.bootstrapServers == null) {this.bootstrapServers = new java.util.ArrayList<java.lang.String>();}
        this.bootstrapServers.add(index, item);
        return (A)this;
    }

    public A setToBootstrapServers(int index,java.lang.String item) {
        if (this.bootstrapServers == null) {this.bootstrapServers = new java.util.ArrayList<java.lang.String>();}
        this.bootstrapServers.set(index, item); return (A)this;
    }

    public A addToBootstrapServers(java.lang.String... items) {
        if (this.bootstrapServers == null) {this.bootstrapServers = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.bootstrapServers.add(item);} return (A)this;
    }

    public A addAllToBootstrapServers(java.util.Collection<java.lang.String> items) {
        if (this.bootstrapServers == null) {this.bootstrapServers = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.bootstrapServers.add(item);} return (A)this;
    }

    public A removeFromBootstrapServers(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.bootstrapServers!= null){ this.bootstrapServers.remove(item);}} return (A)this;
    }

    public A removeAllFromBootstrapServers(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.bootstrapServers!= null){ this.bootstrapServers.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    public java.lang.String getBootstrapServer(int index) {
        return this.bootstrapServers.get(index);
    }

    public java.lang.String getFirstBootstrapServer() {
        return this.bootstrapServers.get(0);
    }

    public java.lang.String getLastBootstrapServer() {
        return this.bootstrapServers.get(bootstrapServers.size() - 1);
    }

    public java.lang.String getMatchingBootstrapServer(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: bootstrapServers) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingBootstrapServer(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: bootstrapServers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withBootstrapServers(java.util.List<java.lang.String> bootstrapServers) {
        if (this.bootstrapServers != null) { _visitables.get("bootstrapServers").removeAll(this.bootstrapServers);}
        if (bootstrapServers != null) {this.bootstrapServers = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : bootstrapServers){this.addToBootstrapServers(item);}} else { this.bootstrapServers = null;} return (A) this;
    }

    public A withBootstrapServers(java.lang.String... bootstrapServers) {
        if (this.bootstrapServers != null) {this.bootstrapServers.clear();}
        if (bootstrapServers != null) {for (java.lang.String item :bootstrapServers){ this.addToBootstrapServers(item);}} return (A) this;
    }

    public java.lang.Boolean hasBootstrapServers() {
        return bootstrapServers != null && !bootstrapServers.isEmpty();
    }

    public A addNewBootstrapServer(java.lang.String arg0) {
        return (A)addToBootstrapServers(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildCeOverrides instead.
     * @return The buildable object.
     */
        public io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides getCeOverrides() {
        return this.ceOverrides!=null?this.ceOverrides.build():null;
    }

    public io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides buildCeOverrides() {
        return this.ceOverrides!=null?this.ceOverrides.build():null;
    }

    public A withCeOverrides(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides ceOverrides) {
        _visitables.get("ceOverrides").remove(this.ceOverrides);
        if (ceOverrides!=null){ this.ceOverrides= new io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder(ceOverrides); _visitables.get("ceOverrides").add(this.ceOverrides);} return (A) this;
    }

    public java.lang.Boolean hasCeOverrides() {
        return this.ceOverrides != null;
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> withNewCeOverrides() {
        return new io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluentImpl.CeOverridesNestedImpl();
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> withNewCeOverridesLike(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides item) {
        return new io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluentImpl.CeOverridesNestedImpl(item);
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> editCeOverrides() {
        return withNewCeOverridesLike(getCeOverrides());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverrides() {
        return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): new io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder().build());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverridesLike(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides item) {
        return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): item);
    }

    public java.lang.String getConsumerGroup() {
        return this.consumerGroup;
    }

    public A withConsumerGroup(java.lang.String consumerGroup) {
        this.consumerGroup=consumerGroup; return (A) this;
    }

    public java.lang.Boolean hasConsumerGroup() {
        return this.consumerGroup != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withConsumerGroup instead.
     */
        public A withNewConsumerGroup(java.lang.String arg0) {
        return (A)withConsumerGroup(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildNet instead.
     * @return The buildable object.
     */
        public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpec getNet() {
        return this.net!=null?this.net.build():null;
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpec buildNet() {
        return this.net!=null?this.net.build():null;
    }

    public A withNet(io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpec net) {
        _visitables.get("net").remove(this.net);
        if (net!=null){ this.net= new io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecBuilder(net); _visitables.get("net").add(this.net);} return (A) this;
    }

    public java.lang.Boolean hasNet() {
        return this.net != null;
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> withNewNet() {
        return new io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluentImpl.NetNestedImpl();
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> withNewNetLike(io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpec item) {
        return new io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluentImpl.NetNestedImpl(item);
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> editNet() {
        return withNewNetLike(getNet());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> editOrNewNet() {
        return withNewNetLike(getNet() != null ? getNet(): new io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecBuilder().build());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> editOrNewNetLike(io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpec item) {
        return withNewNetLike(getNet() != null ? getNet(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSink instead.
     * @return The buildable object.
     */
        public io.fabric8.knative.internal.pkg.apis.duck.v1.Destination getSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public io.fabric8.knative.internal.pkg.apis.duck.v1.Destination buildSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public A withSink(io.fabric8.knative.internal.pkg.apis.duck.v1.Destination sink) {
        _visitables.get("sink").remove(this.sink);
        if (sink!=null){ this.sink= new io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} return (A) this;
    }

    public java.lang.Boolean hasSink() {
        return this.sink != null;
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> withNewSink() {
        return new io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluentImpl.SinkNestedImpl();
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> withNewSinkLike(io.fabric8.knative.internal.pkg.apis.duck.v1.Destination item) {
        return new io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluentImpl.SinkNestedImpl(item);
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> editSink() {
        return withNewSinkLike(getSink());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> editOrNewSink() {
        return withNewSinkLike(getSink() != null ? getSink(): new io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder().build());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> editOrNewSinkLike(io.fabric8.knative.internal.pkg.apis.duck.v1.Destination item) {
        return withNewSinkLike(getSink() != null ? getSink(): item);
    }

    public A addToTopics(int index,java.lang.String item) {
        if (this.topics == null) {this.topics = new java.util.ArrayList<java.lang.String>();}
        this.topics.add(index, item);
        return (A)this;
    }

    public A setToTopics(int index,java.lang.String item) {
        if (this.topics == null) {this.topics = new java.util.ArrayList<java.lang.String>();}
        this.topics.set(index, item); return (A)this;
    }

    public A addToTopics(java.lang.String... items) {
        if (this.topics == null) {this.topics = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.topics.add(item);} return (A)this;
    }

    public A addAllToTopics(java.util.Collection<java.lang.String> items) {
        if (this.topics == null) {this.topics = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.topics.add(item);} return (A)this;
    }

    public A removeFromTopics(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.topics!= null){ this.topics.remove(item);}} return (A)this;
    }

    public A removeAllFromTopics(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.topics!= null){ this.topics.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getTopics() {
        return this.topics;
    }

    public java.lang.String getTopic(int index) {
        return this.topics.get(index);
    }

    public java.lang.String getFirstTopic() {
        return this.topics.get(0);
    }

    public java.lang.String getLastTopic() {
        return this.topics.get(topics.size() - 1);
    }

    public java.lang.String getMatchingTopic(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: topics) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingTopic(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: topics) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTopics(java.util.List<java.lang.String> topics) {
        if (this.topics != null) { _visitables.get("topics").removeAll(this.topics);}
        if (topics != null) {this.topics = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : topics){this.addToTopics(item);}} else { this.topics = null;} return (A) this;
    }

    public A withTopics(java.lang.String... topics) {
        if (this.topics != null) {this.topics.clear();}
        if (topics != null) {for (java.lang.String item :topics){ this.addToTopics(item);}} return (A) this;
    }

    public java.lang.Boolean hasTopics() {
        return topics != null && !topics.isEmpty();
    }

    public A addNewTopic(java.lang.String arg0) {
        return (A)addToTopics(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaSourceSpecFluentImpl that = (KafkaSourceSpecFluentImpl) o;
        if (bootstrapServers != null ? !bootstrapServers.equals(that.bootstrapServers) :that.bootstrapServers != null) return false;
        if (ceOverrides != null ? !ceOverrides.equals(that.ceOverrides) :that.ceOverrides != null) return false;
        if (consumerGroup != null ? !consumerGroup.equals(that.consumerGroup) :that.consumerGroup != null) return false;
        if (net != null ? !net.equals(that.net) :that.net != null) return false;
        if (sink != null ? !sink.equals(that.sink) :that.sink != null) return false;
        if (topics != null ? !topics.equals(that.topics) :that.topics != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(bootstrapServers,  ceOverrides,  consumerGroup,  net,  sink,  topics,  super.hashCode());
    }

    public class CeOverridesNestedImpl<N> extends io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluentImpl<io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<N>> implements io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder builder;

            CeOverridesNestedImpl(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides item) {
                this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder(this, item);
                        
            }

            CeOverridesNestedImpl() {
                this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSourceSpecFluentImpl.this.withCeOverrides(builder.build());
            }

            public N endCeOverrides() {
                return and();
            }
    }


    public class NetNestedImpl<N> extends io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluentImpl<io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<N>> implements io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecBuilder builder;

            NetNestedImpl(io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpec item) {
                this.builder = new io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecBuilder(this, item);
                        
            }

            NetNestedImpl() {
                this.builder = new io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSourceSpecFluentImpl.this.withNet(builder.build());
            }

            public N endNet() {
                return and();
            }
    }


    public class SinkNestedImpl<N> extends io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl<io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<N>> implements io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder builder;

            SinkNestedImpl(io.fabric8.knative.internal.pkg.apis.duck.v1.Destination item) {
                this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder(this, item);
                        
            }

            SinkNestedImpl() {
                this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSourceSpecFluentImpl.this.withSink(builder.build());
            }

            public N endSink() {
                return and();
            }
    }


}
