package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class APIVersionKindSelectorFluentImpl<A extends io.fabric8.knative.sources.v1.APIVersionKindSelectorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.sources.v1.APIVersionKindSelectorFluent<A> {

    private java.lang.String apiVersion;
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.LabelSelectorBuilder selector;

    public APIVersionKindSelectorFluentImpl() {
    }

    public APIVersionKindSelectorFluentImpl(io.fabric8.knative.sources.v1.APIVersionKindSelector instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withSelector(instance.getSelector()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LabelSelector getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public io.fabric8.kubernetes.api.model.LabelSelector buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public java.lang.Boolean hasSelector() {
        return this.selector != null;
    }

    public io.fabric8.knative.sources.v1.APIVersionKindSelectorFluent.SelectorNested<A> withNewSelector() {
        return new io.fabric8.knative.sources.v1.APIVersionKindSelectorFluentImpl.SelectorNestedImpl();
    }

    public io.fabric8.knative.sources.v1.APIVersionKindSelectorFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return new io.fabric8.knative.sources.v1.APIVersionKindSelectorFluentImpl.SelectorNestedImpl(item);
    }

    public io.fabric8.knative.sources.v1.APIVersionKindSelectorFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public io.fabric8.knative.sources.v1.APIVersionKindSelectorFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
    }

    public io.fabric8.knative.sources.v1.APIVersionKindSelectorFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        APIVersionKindSelectorFluentImpl that = (APIVersionKindSelectorFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  selector,  super.hashCode());
    }

    public class SelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.knative.sources.v1.APIVersionKindSelectorFluent.SelectorNested<N>> implements io.fabric8.knative.sources.v1.APIVersionKindSelectorFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;

            SelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) APIVersionKindSelectorFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


}
