package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConfigurationSpecBuilder extends io.fabric8.knative.serving.v1.ConfigurationSpecFluentImpl<io.fabric8.knative.serving.v1.ConfigurationSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.serving.v1.ConfigurationSpec,io.fabric8.knative.serving.v1.ConfigurationSpecBuilder> {

    io.fabric8.knative.serving.v1.ConfigurationSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ConfigurationSpecBuilder() {
        this(true);
    }

    public ConfigurationSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new ConfigurationSpec(), validationEnabled);
    }

    public ConfigurationSpecBuilder(io.fabric8.knative.serving.v1.ConfigurationSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ConfigurationSpecBuilder(io.fabric8.knative.serving.v1.ConfigurationSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ConfigurationSpec(), validationEnabled);
    }

    public ConfigurationSpecBuilder(io.fabric8.knative.serving.v1.ConfigurationSpecFluent<?> fluent,io.fabric8.knative.serving.v1.ConfigurationSpec instance) {
        this(fluent, instance, true);
    }

    public ConfigurationSpecBuilder(io.fabric8.knative.serving.v1.ConfigurationSpecFluent<?> fluent,io.fabric8.knative.serving.v1.ConfigurationSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConfigurationSpecBuilder(io.fabric8.knative.serving.v1.ConfigurationSpec instance) {
        this(instance,true);
    }

    public ConfigurationSpecBuilder(io.fabric8.knative.serving.v1.ConfigurationSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.serving.v1.EditableConfigurationSpec build() {
        EditableConfigurationSpec buildable = new EditableConfigurationSpec(fluent.getTemplate());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConfigurationSpecBuilder that = (ConfigurationSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
