package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ChannelSpecBuilder extends io.fabric8.knative.messaging.v1.ChannelSpecFluentImpl<io.fabric8.knative.messaging.v1.ChannelSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.messaging.v1.ChannelSpec,io.fabric8.knative.messaging.v1.ChannelSpecBuilder> {

    io.fabric8.knative.messaging.v1.ChannelSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ChannelSpecBuilder() {
        this(true);
    }

    public ChannelSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new ChannelSpec(), validationEnabled);
    }

    public ChannelSpecBuilder(io.fabric8.knative.messaging.v1.ChannelSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ChannelSpecBuilder(io.fabric8.knative.messaging.v1.ChannelSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ChannelSpec(), validationEnabled);
    }

    public ChannelSpecBuilder(io.fabric8.knative.messaging.v1.ChannelSpecFluent<?> fluent,io.fabric8.knative.messaging.v1.ChannelSpec instance) {
        this(fluent, instance, true);
    }

    public ChannelSpecBuilder(io.fabric8.knative.messaging.v1.ChannelSpecFluent<?> fluent,io.fabric8.knative.messaging.v1.ChannelSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withChannelTemplate(instance.getChannelTemplate()); 
        fluent.withDelivery(instance.getDelivery()); 
        fluent.withSubscribers(instance.getSubscribers()); 
        this.validationEnabled = validationEnabled; 
    }

    public ChannelSpecBuilder(io.fabric8.knative.messaging.v1.ChannelSpec instance) {
        this(instance,true);
    }

    public ChannelSpecBuilder(io.fabric8.knative.messaging.v1.ChannelSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withChannelTemplate(instance.getChannelTemplate()); 
        this.withDelivery(instance.getDelivery()); 
        this.withSubscribers(instance.getSubscribers()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.messaging.v1.EditableChannelSpec build() {
        EditableChannelSpec buildable = new EditableChannelSpec(fluent.getChannelTemplate(),fluent.getDelivery(),fluent.getSubscribers());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ChannelSpecBuilder that = (ChannelSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
