package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SequenceStatusBuilder extends io.fabric8.knative.flows.v1.SequenceStatusFluentImpl<io.fabric8.knative.flows.v1.SequenceStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.flows.v1.SequenceStatus,io.fabric8.knative.flows.v1.SequenceStatusBuilder> {

    io.fabric8.knative.flows.v1.SequenceStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public SequenceStatusBuilder() {
        this(true);
    }

    public SequenceStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new SequenceStatus(), validationEnabled);
    }

    public SequenceStatusBuilder(io.fabric8.knative.flows.v1.SequenceStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public SequenceStatusBuilder(io.fabric8.knative.flows.v1.SequenceStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new SequenceStatus(), validationEnabled);
    }

    public SequenceStatusBuilder(io.fabric8.knative.flows.v1.SequenceStatusFluent<?> fluent,io.fabric8.knative.flows.v1.SequenceStatus instance) {
        this(fluent, instance, true);
    }

    public SequenceStatusBuilder(io.fabric8.knative.flows.v1.SequenceStatusFluent<?> fluent,io.fabric8.knative.flows.v1.SequenceStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAddress(instance.getAddress()); 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withChannelStatuses(instance.getChannelStatuses()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSubscriptionStatuses(instance.getSubscriptionStatuses()); 
        this.validationEnabled = validationEnabled; 
    }

    public SequenceStatusBuilder(io.fabric8.knative.flows.v1.SequenceStatus instance) {
        this(instance,true);
    }

    public SequenceStatusBuilder(io.fabric8.knative.flows.v1.SequenceStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAddress(instance.getAddress()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withChannelStatuses(instance.getChannelStatuses()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSubscriptionStatuses(instance.getSubscriptionStatuses()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.flows.v1.EditableSequenceStatus build() {
        EditableSequenceStatus buildable = new EditableSequenceStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getChannelStatuses(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSubscriptionStatuses());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SequenceStatusBuilder that = (SequenceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
