package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class RouteStatusFluentImpl<A extends io.fabric8.knative.serving.v1.RouteStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.serving.v1.RouteStatusFluent<A> {

    private io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder address;
    private java.util.Map<java.lang.String,java.lang.String> annotations;
    private java.util.List<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> conditions;
    private java.lang.Long observedGeneration;
    private java.util.List<io.fabric8.knative.serving.v1.TrafficTargetBuilder> traffic;
    private java.lang.String url;

    public RouteStatusFluentImpl() {
    }

    public RouteStatusFluentImpl(io.fabric8.knative.serving.v1.RouteStatus instance) {
        this.withAddress(instance.getAddress()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withTraffic(instance.getTraffic()); 
        this.withUrl(instance.getUrl()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAddress instead.
     * @return The buildable object.
     */
        public io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable getAddress() {
        return this.address!=null?this.address.build():null;
    }

    public io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable buildAddress() {
        return this.address!=null?this.address.build():null;
    }

    public A withAddress(io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable address) {
        _visitables.get("address").remove(this.address);
        if (address!=null){ this.address= new io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder(address); _visitables.get("address").add(this.address);} return (A) this;
    }

    public java.lang.Boolean hasAddress() {
        return this.address != null;
    }

    public A withNewAddress(java.lang.String url) {
        return (A)withAddress(new Addressable(url));
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.AddressNested<A> withNewAddress() {
        return new io.fabric8.knative.serving.v1.RouteStatusFluentImpl.AddressNestedImpl();
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.AddressNested<A> withNewAddressLike(io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable item) {
        return new io.fabric8.knative.serving.v1.RouteStatusFluentImpl.AddressNestedImpl(item);
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.AddressNested<A> editAddress() {
        return withNewAddressLike(getAddress());
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.AddressNested<A> editOrNewAddress() {
        return withNewAddressLike(getAddress() != null ? getAddress(): new io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder().build());
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.AddressNested<A> editOrNewAddressLike(io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable item) {
        return withNewAddressLike(getAddress() != null ? getAddress(): item);
    }

    public A addToAnnotations(java.lang.String key,java.lang.String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.annotations == null && map != null) { this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(java.lang.String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.String> getAnnotations() {
        return this.annotations;
    }

    public <K,V>A withAnnotations(java.util.Map<java.lang.String,java.lang.String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(annotations);} return (A) this;
    }

    public java.lang.Boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToConditions(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(java.util.Collection<io.fabric8.knative.internal.pkg.apis.Condition> items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(java.util.Collection<io.fabric8.knative.internal.pkg.apis.Condition> items) {
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConditions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.knative.internal.pkg.apis.Condition> getConditions() {
        return build(conditions);
    }

    public java.util.List<io.fabric8.knative.internal.pkg.apis.Condition> buildConditions() {
        return build(conditions);
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildMatchingCondition(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        for (io.fabric8.knative.internal.pkg.apis.ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        for (io.fabric8.knative.internal.pkg.apis.ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(java.util.List<io.fabric8.knative.internal.pkg.apis.Condition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>(); for (io.fabric8.knative.internal.pkg.apis.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.knative.internal.pkg.apis.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public java.lang.Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<A> addNewCondition() {
        return new io.fabric8.knative.serving.v1.RouteStatusFluentImpl.ConditionsNestedImpl();
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.knative.internal.pkg.apis.Condition item) {
        return new io.fabric8.knative.serving.v1.RouteStatusFluentImpl.ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
        return new io.fabric8.knative.serving.v1.RouteStatusFluentImpl.ConditionsNestedImpl(index, item);
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public java.lang.Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(java.lang.Long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public java.lang.Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToTraffic(int index,io.fabric8.knative.serving.v1.TrafficTarget item) {
        if (this.traffic == null) {this.traffic = new java.util.ArrayList<io.fabric8.knative.serving.v1.TrafficTargetBuilder>();}
        io.fabric8.knative.serving.v1.TrafficTargetBuilder builder = new io.fabric8.knative.serving.v1.TrafficTargetBuilder(item);_visitables.get("traffic").add(index >= 0 ? index : _visitables.get("traffic").size(), builder);this.traffic.add(index >= 0 ? index : traffic.size(), builder); return (A)this;
    }

    public A setToTraffic(int index,io.fabric8.knative.serving.v1.TrafficTarget item) {
        if (this.traffic == null) {this.traffic = new java.util.ArrayList<io.fabric8.knative.serving.v1.TrafficTargetBuilder>();}
        io.fabric8.knative.serving.v1.TrafficTargetBuilder builder = new io.fabric8.knative.serving.v1.TrafficTargetBuilder(item);
        if (index < 0 || index >= _visitables.get("traffic").size()) { _visitables.get("traffic").add(builder); } else { _visitables.get("traffic").set(index, builder);}
        if (index < 0 || index >= traffic.size()) { traffic.add(builder); } else { traffic.set(index, builder);}
         return (A)this;
    }

    public A addToTraffic(io.fabric8.knative.serving.v1.TrafficTarget... items) {
        if (this.traffic == null) {this.traffic = new java.util.ArrayList<io.fabric8.knative.serving.v1.TrafficTargetBuilder>();}
        for (io.fabric8.knative.serving.v1.TrafficTarget item : items) {io.fabric8.knative.serving.v1.TrafficTargetBuilder builder = new io.fabric8.knative.serving.v1.TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
    }

    public A addAllToTraffic(java.util.Collection<io.fabric8.knative.serving.v1.TrafficTarget> items) {
        if (this.traffic == null) {this.traffic = new java.util.ArrayList<io.fabric8.knative.serving.v1.TrafficTargetBuilder>();}
        for (io.fabric8.knative.serving.v1.TrafficTarget item : items) {io.fabric8.knative.serving.v1.TrafficTargetBuilder builder = new io.fabric8.knative.serving.v1.TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
    }

    public A removeFromTraffic(io.fabric8.knative.serving.v1.TrafficTarget... items) {
        for (io.fabric8.knative.serving.v1.TrafficTarget item : items) {io.fabric8.knative.serving.v1.TrafficTargetBuilder builder = new io.fabric8.knative.serving.v1.TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
    }

    public A removeAllFromTraffic(java.util.Collection<io.fabric8.knative.serving.v1.TrafficTarget> items) {
        for (io.fabric8.knative.serving.v1.TrafficTarget item : items) {io.fabric8.knative.serving.v1.TrafficTargetBuilder builder = new io.fabric8.knative.serving.v1.TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTraffic(java.util.function.Predicate<io.fabric8.knative.serving.v1.TrafficTargetBuilder> predicate) {
        if (traffic == null) return (A) this;
        final Iterator<io.fabric8.knative.serving.v1.TrafficTargetBuilder> each = traffic.iterator();
        final List visitables = _visitables.get("traffic");
        while (each.hasNext()) {
          io.fabric8.knative.serving.v1.TrafficTargetBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTraffic instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.knative.serving.v1.TrafficTarget> getTraffic() {
        return build(traffic);
    }

    public java.util.List<io.fabric8.knative.serving.v1.TrafficTarget> buildTraffic() {
        return build(traffic);
    }

    public io.fabric8.knative.serving.v1.TrafficTarget buildTraffic(int index) {
        return this.traffic.get(index).build();
    }

    public io.fabric8.knative.serving.v1.TrafficTarget buildFirstTraffic() {
        return this.traffic.get(0).build();
    }

    public io.fabric8.knative.serving.v1.TrafficTarget buildLastTraffic() {
        return this.traffic.get(traffic.size() - 1).build();
    }

    public io.fabric8.knative.serving.v1.TrafficTarget buildMatchingTraffic(java.util.function.Predicate<io.fabric8.knative.serving.v1.TrafficTargetBuilder> predicate) {
        for (io.fabric8.knative.serving.v1.TrafficTargetBuilder item: traffic) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingTraffic(java.util.function.Predicate<io.fabric8.knative.serving.v1.TrafficTargetBuilder> predicate) {
        for (io.fabric8.knative.serving.v1.TrafficTargetBuilder item: traffic) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTraffic(java.util.List<io.fabric8.knative.serving.v1.TrafficTarget> traffic) {
        if (this.traffic != null) { _visitables.get("traffic").removeAll(this.traffic);}
        if (traffic != null) {this.traffic = new java.util.ArrayList<io.fabric8.knative.serving.v1.TrafficTargetBuilder>(); for (io.fabric8.knative.serving.v1.TrafficTarget item : traffic){this.addToTraffic(item);}} else { this.traffic = null;} return (A) this;
    }

    public A withTraffic(io.fabric8.knative.serving.v1.TrafficTarget... traffic) {
        if (this.traffic != null) {this.traffic.clear();}
        if (traffic != null) {for (io.fabric8.knative.serving.v1.TrafficTarget item :traffic){ this.addToTraffic(item);}} return (A) this;
    }

    public java.lang.Boolean hasTraffic() {
        return traffic != null && !traffic.isEmpty();
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<A> addNewTraffic() {
        return new io.fabric8.knative.serving.v1.RouteStatusFluentImpl.TrafficNestedImpl();
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<A> addNewTrafficLike(io.fabric8.knative.serving.v1.TrafficTarget item) {
        return new io.fabric8.knative.serving.v1.RouteStatusFluentImpl.TrafficNestedImpl(-1, item);
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<A> setNewTrafficLike(int index,io.fabric8.knative.serving.v1.TrafficTarget item) {
        return new io.fabric8.knative.serving.v1.RouteStatusFluentImpl.TrafficNestedImpl(index, item);
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<A> editTraffic(int index) {
        if (traffic.size() <= index) throw new RuntimeException("Can't edit traffic. Index exceeds size.");
        return setNewTrafficLike(index, buildTraffic(index));
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<A> editFirstTraffic() {
        if (traffic.size() == 0) throw new RuntimeException("Can't edit first traffic. The list is empty.");
        return setNewTrafficLike(0, buildTraffic(0));
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<A> editLastTraffic() {
        int index = traffic.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last traffic. The list is empty.");
        return setNewTrafficLike(index, buildTraffic(index));
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<A> editMatchingTraffic(java.util.function.Predicate<io.fabric8.knative.serving.v1.TrafficTargetBuilder> predicate) {
        int index = -1;
        for (int i=0;i<traffic.size();i++) { 
        if (predicate.test(traffic.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching traffic. No match found.");
        return setNewTrafficLike(index, buildTraffic(index));
    }

    public java.lang.String getUrl() {
        return this.url;
    }

    public A withUrl(java.lang.String url) {
        this.url=url; return (A) this;
    }

    public java.lang.Boolean hasUrl() {
        return this.url != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUrl instead.
     */
        public A withNewUrl(java.lang.String arg0) {
        return (A)withUrl(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RouteStatusFluentImpl that = (RouteStatusFluentImpl) o;
        if (address != null ? !address.equals(that.address) :that.address != null) return false;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
        if (traffic != null ? !traffic.equals(that.traffic) :that.traffic != null) return false;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(address,  annotations,  conditions,  observedGeneration,  traffic,  url,  super.hashCode());
    }

    public class AddressNestedImpl<N> extends io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl<io.fabric8.knative.serving.v1.RouteStatusFluent.AddressNested<N>> implements io.fabric8.knative.serving.v1.RouteStatusFluent.AddressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder builder;

            AddressNestedImpl(io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable item) {
                this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder(this, item);
                        
            }

            AddressNestedImpl() {
                this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder(this);
                        
            }

            public N and() {
                return (N) RouteStatusFluentImpl.this.withAddress(builder.build());
            }

            public N endAddress() {
                return and();
            }
    }


    public class ConditionsNestedImpl<N> extends io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl<io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<N>> implements io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
                this.index = index;
                this.builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(this);
                        
            }

            public N and() {
                return (N) RouteStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class TrafficNestedImpl<N> extends io.fabric8.knative.serving.v1.TrafficTargetFluentImpl<io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<N>> implements io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.serving.v1.TrafficTargetBuilder builder;
        private final int index;

            TrafficNestedImpl(int index,io.fabric8.knative.serving.v1.TrafficTarget item) {
                this.index = index;
                this.builder = new io.fabric8.knative.serving.v1.TrafficTargetBuilder(this, item);
                        
            }

            TrafficNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.knative.serving.v1.TrafficTargetBuilder(this);
                        
            }

            public N and() {
                return (N) RouteStatusFluentImpl.this.setToTraffic(index,builder.build());
            }

            public N endTraffic() {
                return and();
            }
    }


}
