package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerStatusBuilder extends io.fabric8.knative.serving.v1.ContainerStatusFluentImpl<io.fabric8.knative.serving.v1.ContainerStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.serving.v1.ContainerStatus,io.fabric8.knative.serving.v1.ContainerStatusBuilder> {

    io.fabric8.knative.serving.v1.ContainerStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ContainerStatusBuilder() {
        this(true);
    }

    public ContainerStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new ContainerStatus(), validationEnabled);
    }

    public ContainerStatusBuilder(io.fabric8.knative.serving.v1.ContainerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ContainerStatusBuilder(io.fabric8.knative.serving.v1.ContainerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ContainerStatus(), validationEnabled);
    }

    public ContainerStatusBuilder(io.fabric8.knative.serving.v1.ContainerStatusFluent<?> fluent,io.fabric8.knative.serving.v1.ContainerStatus instance) {
        this(fluent, instance, true);
    }

    public ContainerStatusBuilder(io.fabric8.knative.serving.v1.ContainerStatusFluent<?> fluent,io.fabric8.knative.serving.v1.ContainerStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withImageDigest(instance.getImageDigest()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public ContainerStatusBuilder(io.fabric8.knative.serving.v1.ContainerStatus instance) {
        this(instance,true);
    }

    public ContainerStatusBuilder(io.fabric8.knative.serving.v1.ContainerStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withImageDigest(instance.getImageDigest()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.serving.v1.EditableContainerStatus build() {
        EditableContainerStatus buildable = new EditableContainerStatus(fluent.getImageDigest(),fluent.getName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContainerStatusBuilder that = (ContainerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
