package io.fabric8.knative.flows.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpec;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

public class SequenceSpecFluentImpl<A extends io.fabric8.knative.flows.v1.SequenceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.flows.v1.SequenceSpecFluent<A> {

    private io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder channelTemplate;
    private io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder reply;
    private java.util.List<io.fabric8.knative.flows.v1.SequenceStepBuilder> steps;

    public SequenceSpecFluentImpl() {
    }

    public SequenceSpecFluentImpl(io.fabric8.knative.flows.v1.SequenceSpec instance) {
        this.withChannelTemplate(instance.getChannelTemplate()); 
        this.withReply(instance.getReply()); 
        this.withSteps(instance.getSteps()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildChannelTemplate instead.
     * @return The buildable object.
     */
        public io.fabric8.knative.messaging.v1.ChannelTemplateSpec getChannelTemplate() {
        return this.channelTemplate!=null?this.channelTemplate.build():null;
    }

    public io.fabric8.knative.messaging.v1.ChannelTemplateSpec buildChannelTemplate() {
        return this.channelTemplate!=null?this.channelTemplate.build():null;
    }

    public A withChannelTemplate(io.fabric8.knative.messaging.v1.ChannelTemplateSpec channelTemplate) {
        _visitables.get("channelTemplate").remove(this.channelTemplate);
        if (channelTemplate!=null){ this.channelTemplate= new io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder(channelTemplate); _visitables.get("channelTemplate").add(this.channelTemplate);} return (A) this;
    }

    public java.lang.Boolean hasChannelTemplate() {
        return this.channelTemplate != null;
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ChannelTemplateNested<A> withNewChannelTemplate() {
        return new io.fabric8.knative.flows.v1.SequenceSpecFluentImpl.ChannelTemplateNestedImpl();
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ChannelTemplateNested<A> withNewChannelTemplateLike(io.fabric8.knative.messaging.v1.ChannelTemplateSpec item) {
        return new io.fabric8.knative.flows.v1.SequenceSpecFluentImpl.ChannelTemplateNestedImpl(item);
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ChannelTemplateNested<A> editChannelTemplate() {
        return withNewChannelTemplateLike(getChannelTemplate());
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplate() {
        return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): new io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder().build());
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplateLike(io.fabric8.knative.messaging.v1.ChannelTemplateSpec item) {
        return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReply instead.
     * @return The buildable object.
     */
        public io.fabric8.knative.internal.pkg.apis.duck.v1.Destination getReply() {
        return this.reply!=null?this.reply.build():null;
    }

    public io.fabric8.knative.internal.pkg.apis.duck.v1.Destination buildReply() {
        return this.reply!=null?this.reply.build():null;
    }

    public A withReply(io.fabric8.knative.internal.pkg.apis.duck.v1.Destination reply) {
        _visitables.get("reply").remove(this.reply);
        if (reply!=null){ this.reply= new io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder(reply); _visitables.get("reply").add(this.reply);} return (A) this;
    }

    public java.lang.Boolean hasReply() {
        return this.reply != null;
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ReplyNested<A> withNewReply() {
        return new io.fabric8.knative.flows.v1.SequenceSpecFluentImpl.ReplyNestedImpl();
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ReplyNested<A> withNewReplyLike(io.fabric8.knative.internal.pkg.apis.duck.v1.Destination item) {
        return new io.fabric8.knative.flows.v1.SequenceSpecFluentImpl.ReplyNestedImpl(item);
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ReplyNested<A> editReply() {
        return withNewReplyLike(getReply());
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ReplyNested<A> editOrNewReply() {
        return withNewReplyLike(getReply() != null ? getReply(): new io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder().build());
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ReplyNested<A> editOrNewReplyLike(io.fabric8.knative.internal.pkg.apis.duck.v1.Destination item) {
        return withNewReplyLike(getReply() != null ? getReply(): item);
    }

    public A addToSteps(int index,io.fabric8.knative.flows.v1.SequenceStep item) {
        if (this.steps == null) {this.steps = new java.util.ArrayList<io.fabric8.knative.flows.v1.SequenceStepBuilder>();}
        io.fabric8.knative.flows.v1.SequenceStepBuilder builder = new io.fabric8.knative.flows.v1.SequenceStepBuilder(item);_visitables.get("steps").add(index >= 0 ? index : _visitables.get("steps").size(), builder);this.steps.add(index >= 0 ? index : steps.size(), builder); return (A)this;
    }

    public A setToSteps(int index,io.fabric8.knative.flows.v1.SequenceStep item) {
        if (this.steps == null) {this.steps = new java.util.ArrayList<io.fabric8.knative.flows.v1.SequenceStepBuilder>();}
        io.fabric8.knative.flows.v1.SequenceStepBuilder builder = new io.fabric8.knative.flows.v1.SequenceStepBuilder(item);
        if (index < 0 || index >= _visitables.get("steps").size()) { _visitables.get("steps").add(builder); } else { _visitables.get("steps").set(index, builder);}
        if (index < 0 || index >= steps.size()) { steps.add(builder); } else { steps.set(index, builder);}
         return (A)this;
    }

    public A addToSteps(io.fabric8.knative.flows.v1.SequenceStep... items) {
        if (this.steps == null) {this.steps = new java.util.ArrayList<io.fabric8.knative.flows.v1.SequenceStepBuilder>();}
        for (io.fabric8.knative.flows.v1.SequenceStep item : items) {io.fabric8.knative.flows.v1.SequenceStepBuilder builder = new io.fabric8.knative.flows.v1.SequenceStepBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
    }

    public A addAllToSteps(java.util.Collection<io.fabric8.knative.flows.v1.SequenceStep> items) {
        if (this.steps == null) {this.steps = new java.util.ArrayList<io.fabric8.knative.flows.v1.SequenceStepBuilder>();}
        for (io.fabric8.knative.flows.v1.SequenceStep item : items) {io.fabric8.knative.flows.v1.SequenceStepBuilder builder = new io.fabric8.knative.flows.v1.SequenceStepBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
    }

    public A removeFromSteps(io.fabric8.knative.flows.v1.SequenceStep... items) {
        for (io.fabric8.knative.flows.v1.SequenceStep item : items) {io.fabric8.knative.flows.v1.SequenceStepBuilder builder = new io.fabric8.knative.flows.v1.SequenceStepBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
    }

    public A removeAllFromSteps(java.util.Collection<io.fabric8.knative.flows.v1.SequenceStep> items) {
        for (io.fabric8.knative.flows.v1.SequenceStep item : items) {io.fabric8.knative.flows.v1.SequenceStepBuilder builder = new io.fabric8.knative.flows.v1.SequenceStepBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSteps(java.util.function.Predicate<io.fabric8.knative.flows.v1.SequenceStepBuilder> predicate) {
        if (steps == null) return (A) this;
        final Iterator<io.fabric8.knative.flows.v1.SequenceStepBuilder> each = steps.iterator();
        final List visitables = _visitables.get("steps");
        while (each.hasNext()) {
          io.fabric8.knative.flows.v1.SequenceStepBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSteps instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.knative.flows.v1.SequenceStep> getSteps() {
        return build(steps);
    }

    public java.util.List<io.fabric8.knative.flows.v1.SequenceStep> buildSteps() {
        return build(steps);
    }

    public io.fabric8.knative.flows.v1.SequenceStep buildStep(int index) {
        return this.steps.get(index).build();
    }

    public io.fabric8.knative.flows.v1.SequenceStep buildFirstStep() {
        return this.steps.get(0).build();
    }

    public io.fabric8.knative.flows.v1.SequenceStep buildLastStep() {
        return this.steps.get(steps.size() - 1).build();
    }

    public io.fabric8.knative.flows.v1.SequenceStep buildMatchingStep(java.util.function.Predicate<io.fabric8.knative.flows.v1.SequenceStepBuilder> predicate) {
        for (io.fabric8.knative.flows.v1.SequenceStepBuilder item: steps) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingStep(java.util.function.Predicate<io.fabric8.knative.flows.v1.SequenceStepBuilder> predicate) {
        for (io.fabric8.knative.flows.v1.SequenceStepBuilder item: steps) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSteps(java.util.List<io.fabric8.knative.flows.v1.SequenceStep> steps) {
        if (this.steps != null) { _visitables.get("steps").removeAll(this.steps);}
        if (steps != null) {this.steps = new java.util.ArrayList<io.fabric8.knative.flows.v1.SequenceStepBuilder>(); for (io.fabric8.knative.flows.v1.SequenceStep item : steps){this.addToSteps(item);}} else { this.steps = null;} return (A) this;
    }

    public A withSteps(io.fabric8.knative.flows.v1.SequenceStep... steps) {
        if (this.steps != null) {this.steps.clear();}
        if (steps != null) {for (io.fabric8.knative.flows.v1.SequenceStep item :steps){ this.addToSteps(item);}} return (A) this;
    }

    public java.lang.Boolean hasSteps() {
        return steps != null && !steps.isEmpty();
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<A> addNewStep() {
        return new io.fabric8.knative.flows.v1.SequenceSpecFluentImpl.StepsNestedImpl();
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<A> addNewStepLike(io.fabric8.knative.flows.v1.SequenceStep item) {
        return new io.fabric8.knative.flows.v1.SequenceSpecFluentImpl.StepsNestedImpl(-1, item);
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<A> setNewStepLike(int index,io.fabric8.knative.flows.v1.SequenceStep item) {
        return new io.fabric8.knative.flows.v1.SequenceSpecFluentImpl.StepsNestedImpl(index, item);
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<A> editStep(int index) {
        if (steps.size() <= index) throw new RuntimeException("Can't edit steps. Index exceeds size.");
        return setNewStepLike(index, buildStep(index));
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<A> editFirstStep() {
        if (steps.size() == 0) throw new RuntimeException("Can't edit first steps. The list is empty.");
        return setNewStepLike(0, buildStep(0));
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<A> editLastStep() {
        int index = steps.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last steps. The list is empty.");
        return setNewStepLike(index, buildStep(index));
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<A> editMatchingStep(java.util.function.Predicate<io.fabric8.knative.flows.v1.SequenceStepBuilder> predicate) {
        int index = -1;
        for (int i=0;i<steps.size();i++) { 
        if (predicate.test(steps.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching steps. No match found.");
        return setNewStepLike(index, buildStep(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SequenceSpecFluentImpl that = (SequenceSpecFluentImpl) o;
        if (channelTemplate != null ? !channelTemplate.equals(that.channelTemplate) :that.channelTemplate != null) return false;
        if (reply != null ? !reply.equals(that.reply) :that.reply != null) return false;
        if (steps != null ? !steps.equals(that.steps) :that.steps != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(channelTemplate,  reply,  steps,  super.hashCode());
    }

    public class ChannelTemplateNestedImpl<N> extends io.fabric8.knative.messaging.v1.ChannelTemplateSpecFluentImpl<io.fabric8.knative.flows.v1.SequenceSpecFluent.ChannelTemplateNested<N>> implements io.fabric8.knative.flows.v1.SequenceSpecFluent.ChannelTemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder builder;

            ChannelTemplateNestedImpl(io.fabric8.knative.messaging.v1.ChannelTemplateSpec item) {
                this.builder = new io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder(this, item);
                        
            }

            ChannelTemplateNestedImpl() {
                this.builder = new io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder(this);
                        
            }

            public N and() {
                return (N) SequenceSpecFluentImpl.this.withChannelTemplate(builder.build());
            }

            public N endChannelTemplate() {
                return and();
            }
    }


    public class ReplyNestedImpl<N> extends io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl<io.fabric8.knative.flows.v1.SequenceSpecFluent.ReplyNested<N>> implements io.fabric8.knative.flows.v1.SequenceSpecFluent.ReplyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder builder;

            ReplyNestedImpl(io.fabric8.knative.internal.pkg.apis.duck.v1.Destination item) {
                this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder(this, item);
                        
            }

            ReplyNestedImpl() {
                this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder(this);
                        
            }

            public N and() {
                return (N) SequenceSpecFluentImpl.this.withReply(builder.build());
            }

            public N endReply() {
                return and();
            }
    }


    public class StepsNestedImpl<N> extends io.fabric8.knative.flows.v1.SequenceStepFluentImpl<io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<N>> implements io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.flows.v1.SequenceStepBuilder builder;
        private final int index;

            StepsNestedImpl(int index,io.fabric8.knative.flows.v1.SequenceStep item) {
                this.index = index;
                this.builder = new io.fabric8.knative.flows.v1.SequenceStepBuilder(this, item);
                        
            }

            StepsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.knative.flows.v1.SequenceStepBuilder(this);
                        
            }

            public N and() {
                return (N) SequenceSpecFluentImpl.this.setToSteps(index,builder.build());
            }

            public N endStep() {
                return and();
            }
    }


}
