package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ParallelStatusBuilder extends io.fabric8.knative.flows.v1.ParallelStatusFluentImpl<io.fabric8.knative.flows.v1.ParallelStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.flows.v1.ParallelStatus,io.fabric8.knative.flows.v1.ParallelStatusBuilder> {

    io.fabric8.knative.flows.v1.ParallelStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ParallelStatusBuilder() {
        this(true);
    }

    public ParallelStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new ParallelStatus(), validationEnabled);
    }

    public ParallelStatusBuilder(io.fabric8.knative.flows.v1.ParallelStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ParallelStatusBuilder(io.fabric8.knative.flows.v1.ParallelStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ParallelStatus(), validationEnabled);
    }

    public ParallelStatusBuilder(io.fabric8.knative.flows.v1.ParallelStatusFluent<?> fluent,io.fabric8.knative.flows.v1.ParallelStatus instance) {
        this(fluent, instance, true);
    }

    public ParallelStatusBuilder(io.fabric8.knative.flows.v1.ParallelStatusFluent<?> fluent,io.fabric8.knative.flows.v1.ParallelStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAddress(instance.getAddress()); 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withBranchStatuses(instance.getBranchStatuses()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withIngressChannelStatus(instance.getIngressChannelStatus()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        this.validationEnabled = validationEnabled; 
    }

    public ParallelStatusBuilder(io.fabric8.knative.flows.v1.ParallelStatus instance) {
        this(instance,true);
    }

    public ParallelStatusBuilder(io.fabric8.knative.flows.v1.ParallelStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAddress(instance.getAddress()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withBranchStatuses(instance.getBranchStatuses()); 
        this.withConditions(instance.getConditions()); 
        this.withIngressChannelStatus(instance.getIngressChannelStatus()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.flows.v1.EditableParallelStatus build() {
        EditableParallelStatus buildable = new EditableParallelStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getBranchStatuses(),fluent.getConditions(),fluent.getIngressChannelStatus(),fluent.getObservedGeneration());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ParallelStatusBuilder that = (ParallelStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
