package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ParallelBuilder extends io.fabric8.knative.flows.v1.ParallelFluentImpl<io.fabric8.knative.flows.v1.ParallelBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.flows.v1.Parallel,io.fabric8.knative.flows.v1.ParallelBuilder> {

    io.fabric8.knative.flows.v1.ParallelFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ParallelBuilder() {
        this(true);
    }

    public ParallelBuilder(java.lang.Boolean validationEnabled) {
        this(new Parallel(), validationEnabled);
    }

    public ParallelBuilder(io.fabric8.knative.flows.v1.ParallelFluent<?> fluent) {
        this(fluent, true);
    }

    public ParallelBuilder(io.fabric8.knative.flows.v1.ParallelFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Parallel(), validationEnabled);
    }

    public ParallelBuilder(io.fabric8.knative.flows.v1.ParallelFluent<?> fluent,io.fabric8.knative.flows.v1.Parallel instance) {
        this(fluent, instance, true);
    }

    public ParallelBuilder(io.fabric8.knative.flows.v1.ParallelFluent<?> fluent,io.fabric8.knative.flows.v1.Parallel instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ParallelBuilder(io.fabric8.knative.flows.v1.Parallel instance) {
        this(instance,true);
    }

    public ParallelBuilder(io.fabric8.knative.flows.v1.Parallel instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.flows.v1.EditableParallel build() {
        EditableParallel buildable = new EditableParallel(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ParallelBuilder that = (ParallelBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
