package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceStatusBuilder extends io.fabric8.knative.serving.v1.ServiceStatusFluentImpl<io.fabric8.knative.serving.v1.ServiceStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.serving.v1.ServiceStatus,io.fabric8.knative.serving.v1.ServiceStatusBuilder> {

    io.fabric8.knative.serving.v1.ServiceStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ServiceStatusBuilder() {
        this(true);
    }

    public ServiceStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new ServiceStatus(), validationEnabled);
    }

    public ServiceStatusBuilder(io.fabric8.knative.serving.v1.ServiceStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceStatusBuilder(io.fabric8.knative.serving.v1.ServiceStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ServiceStatus(), validationEnabled);
    }

    public ServiceStatusBuilder(io.fabric8.knative.serving.v1.ServiceStatusFluent<?> fluent,io.fabric8.knative.serving.v1.ServiceStatus instance) {
        this(fluent, instance, true);
    }

    public ServiceStatusBuilder(io.fabric8.knative.serving.v1.ServiceStatusFluent<?> fluent,io.fabric8.knative.serving.v1.ServiceStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAddress(instance.getAddress()); 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withLatestCreatedRevisionName(instance.getLatestCreatedRevisionName()); 
        fluent.withLatestReadyRevisionName(instance.getLatestReadyRevisionName()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withTraffic(instance.getTraffic()); 
        fluent.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceStatusBuilder(io.fabric8.knative.serving.v1.ServiceStatus instance) {
        this(instance,true);
    }

    public ServiceStatusBuilder(io.fabric8.knative.serving.v1.ServiceStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAddress(instance.getAddress()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withConditions(instance.getConditions()); 
        this.withLatestCreatedRevisionName(instance.getLatestCreatedRevisionName()); 
        this.withLatestReadyRevisionName(instance.getLatestReadyRevisionName()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withTraffic(instance.getTraffic()); 
        this.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.serving.v1.EditableServiceStatus build() {
        EditableServiceStatus buildable = new EditableServiceStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getConditions(),fluent.getLatestCreatedRevisionName(),fluent.getLatestReadyRevisionName(),fluent.getObservedGeneration(),fluent.getTraffic(),fluent.getUrl());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceStatusBuilder that = (ServiceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
