package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerStatusesBuilder extends io.fabric8.knative.serving.v1.ContainerStatusesFluentImpl<io.fabric8.knative.serving.v1.ContainerStatusesBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.serving.v1.ContainerStatuses,io.fabric8.knative.serving.v1.ContainerStatusesBuilder> {

    io.fabric8.knative.serving.v1.ContainerStatusesFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ContainerStatusesBuilder() {
        this(true);
    }

    public ContainerStatusesBuilder(java.lang.Boolean validationEnabled) {
        this(new ContainerStatuses(), validationEnabled);
    }

    public ContainerStatusesBuilder(io.fabric8.knative.serving.v1.ContainerStatusesFluent<?> fluent) {
        this(fluent, true);
    }

    public ContainerStatusesBuilder(io.fabric8.knative.serving.v1.ContainerStatusesFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ContainerStatuses(), validationEnabled);
    }

    public ContainerStatusesBuilder(io.fabric8.knative.serving.v1.ContainerStatusesFluent<?> fluent,io.fabric8.knative.serving.v1.ContainerStatuses instance) {
        this(fluent, instance, true);
    }

    public ContainerStatusesBuilder(io.fabric8.knative.serving.v1.ContainerStatusesFluent<?> fluent,io.fabric8.knative.serving.v1.ContainerStatuses instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withImageDigest(instance.getImageDigest()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public ContainerStatusesBuilder(io.fabric8.knative.serving.v1.ContainerStatuses instance) {
        this(instance,true);
    }

    public ContainerStatusesBuilder(io.fabric8.knative.serving.v1.ContainerStatuses instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withImageDigest(instance.getImageDigest()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.serving.v1.EditableContainerStatuses build() {
        EditableContainerStatuses buildable = new EditableContainerStatuses(fluent.getImageDigest(),fluent.getName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContainerStatusesBuilder that = (ContainerStatusesBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
