package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIVersionKindBuilder extends io.fabric8.knative.sources.v1beta1.APIVersionKindFluentImpl<io.fabric8.knative.sources.v1beta1.APIVersionKindBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.sources.v1beta1.APIVersionKind,io.fabric8.knative.sources.v1beta1.APIVersionKindBuilder> {

    io.fabric8.knative.sources.v1beta1.APIVersionKindFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public APIVersionKindBuilder() {
        this(true);
    }

    public APIVersionKindBuilder(java.lang.Boolean validationEnabled) {
        this(new APIVersionKind(), validationEnabled);
    }

    public APIVersionKindBuilder(io.fabric8.knative.sources.v1beta1.APIVersionKindFluent<?> fluent) {
        this(fluent, true);
    }

    public APIVersionKindBuilder(io.fabric8.knative.sources.v1beta1.APIVersionKindFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new APIVersionKind(), validationEnabled);
    }

    public APIVersionKindBuilder(io.fabric8.knative.sources.v1beta1.APIVersionKindFluent<?> fluent,io.fabric8.knative.sources.v1beta1.APIVersionKind instance) {
        this(fluent, instance, true);
    }

    public APIVersionKindBuilder(io.fabric8.knative.sources.v1beta1.APIVersionKindFluent<?> fluent,io.fabric8.knative.sources.v1beta1.APIVersionKind instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIVersionKindBuilder(io.fabric8.knative.sources.v1beta1.APIVersionKind instance) {
        this(instance,true);
    }

    public APIVersionKindBuilder(io.fabric8.knative.sources.v1beta1.APIVersionKind instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.sources.v1beta1.EditableAPIVersionKind build() {
        EditableAPIVersionKind buildable = new EditableAPIVersionKind(fluent.getApiVersion(),fluent.getKind());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIVersionKindBuilder that = (APIVersionKindBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
