/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.serving.v1;

import io.fabric8.knative.serving.v1.RevisionSpec;
import io.fabric8.knative.serving.v1.RevisionSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import io.fabric8.kubernetes.api.model.PodReadinessGate;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RevisionSpecFluentImpl<A extends RevisionSpecFluent<A>>
extends BaseFluent<A>
implements RevisionSpecFluent<A> {
    private Long activeDeadlineSeconds;
    private Affinity affinity;
    private Boolean automountServiceAccountToken;
    private Long containerConcurrency;
    private List<ContainerBuilder> containers;
    private PodDNSConfig dnsConfig;
    private String dnsPolicy;
    private Boolean enableServiceLinks;
    private List<EphemeralContainer> ephemeralContainers;
    private List<HostAlias> hostAliases;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private String hostname;
    private List<LocalObjectReference> imagePullSecrets;
    private List<ContainerBuilder> initContainers;
    private String nodeName;
    private Map<String, String> nodeSelector;
    private Map<String, Quantity> overhead;
    private String preemptionPolicy;
    private Integer priority;
    private String priorityClassName;
    private List<PodReadinessGate> readinessGates;
    private String restartPolicy;
    private String runtimeClassName;
    private String schedulerName;
    private PodSecurityContext securityContext;
    private String serviceAccount;
    private String serviceAccountName;
    private Boolean setHostnameAsFQDN;
    private Boolean shareProcessNamespace;
    private String subdomain;
    private Long terminationGracePeriodSeconds;
    private Long timeoutSeconds;
    private List<Toleration> tolerations;
    private List<TopologySpreadConstraint> topologySpreadConstraints;
    private List<VolumeBuilder> volumes;

    public RevisionSpecFluentImpl() {
    }

    public RevisionSpecFluentImpl(RevisionSpec instance) {
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withAffinity(instance.getAffinity());
        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
        this.withContainerConcurrency(instance.getContainerConcurrency());
        this.withContainers(instance.getContainers());
        this.withDnsConfig(instance.getDnsConfig());
        this.withDnsPolicy(instance.getDnsPolicy());
        this.withEnableServiceLinks(instance.getEnableServiceLinks());
        this.withEphemeralContainers(instance.getEphemeralContainers());
        this.withHostAliases(instance.getHostAliases());
        this.withHostIPC(instance.getHostIPC());
        this.withHostNetwork(instance.getHostNetwork());
        this.withHostPID(instance.getHostPID());
        this.withHostname(instance.getHostname());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withInitContainers(instance.getInitContainers());
        this.withNodeName(instance.getNodeName());
        this.withNodeSelector(instance.getNodeSelector());
        this.withOverhead(instance.getOverhead());
        this.withPreemptionPolicy(instance.getPreemptionPolicy());
        this.withPriority(instance.getPriority());
        this.withPriorityClassName(instance.getPriorityClassName());
        this.withReadinessGates(instance.getReadinessGates());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withRuntimeClassName(instance.getRuntimeClassName());
        this.withSchedulerName(instance.getSchedulerName());
        this.withSecurityContext(instance.getSecurityContext());
        this.withServiceAccount(instance.getServiceAccount());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withSetHostnameAsFQDN(instance.getSetHostnameAsFQDN());
        this.withShareProcessNamespace(instance.getShareProcessNamespace());
        this.withSubdomain(instance.getSubdomain());
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.withTolerations(instance.getTolerations());
        this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @Override
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    @Override
    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return (A)this;
    }

    @Override
    public Boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    @Override
    public Long getContainerConcurrency() {
        return this.containerConcurrency;
    }

    @Override
    public A withContainerConcurrency(Long containerConcurrency) {
        this.containerConcurrency = containerConcurrency;
        return (A)this;
    }

    @Override
    public Boolean hasContainerConcurrency() {
        return this.containerConcurrency != null;
    }

    @Override
    public A addToContainers(Integer index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get((Object)"containers").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"containers").size(), builder);
        this.containers.add(index >= 0 ? index.intValue() : this.containers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainers(Integer index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"containers").size()) {
            this._visitables.get((Object)"containers").add(builder);
        } else {
            this._visitables.get((Object)"containers").set(index, builder);
        }
        if (index < 0 || index >= this.containers.size()) {
            this.containers.add(builder);
        } else {
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
        if (this.containers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.containers.iterator();
        List visitables = this._visitables.get((Object)"containers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Container> getContainers() {
        return RevisionSpecFluentImpl.build(this.containers);
    }

    @Override
    public List<Container> buildContainers() {
        return RevisionSpecFluentImpl.build(this.containers);
    }

    @Override
    public Container buildContainer(Integer index) {
        return this.containers.get(index).build();
    }

    @Override
    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    @Override
    public Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    @Override
    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainers(List<Container> containers) {
        if (this.containers != null) {
            this._visitables.get((Object)"containers").removeAll(this.containers);
        }
        if (containers != null) {
            this.containers = new ArrayList<ContainerBuilder>();
            for (Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)this;
    }

    @Override
    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    @Override
    public RevisionSpecFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    @Override
    public RevisionSpecFluent.ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNestedImpl(-1, item);
    }

    @Override
    public RevisionSpecFluent.ContainersNested<A> setNewContainerLike(Integer index, Container item) {
        return new ContainersNestedImpl(index, item);
    }

    @Override
    public RevisionSpecFluent.ContainersNested<A> editContainer(Integer index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public RevisionSpecFluent.ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    @Override
    public RevisionSpecFluent.ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public RevisionSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public PodDNSConfig getDnsConfig() {
        return this.dnsConfig;
    }

    @Override
    public A withDnsConfig(PodDNSConfig dnsConfig) {
        this.dnsConfig = dnsConfig;
        return (A)this;
    }

    @Override
    public Boolean hasDnsConfig() {
        return this.dnsConfig != null;
    }

    @Override
    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    @Override
    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewDnsPolicy(String arg0) {
        return this.withDnsPolicy(new String(arg0));
    }

    @Override
    public Boolean getEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    @Override
    public A withEnableServiceLinks(Boolean enableServiceLinks) {
        this.enableServiceLinks = enableServiceLinks;
        return (A)this;
    }

    @Override
    public Boolean hasEnableServiceLinks() {
        return this.enableServiceLinks != null;
    }

    @Override
    public A addToEphemeralContainers(Integer index, EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        this.ephemeralContainers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEphemeralContainers(Integer index, EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        this.ephemeralContainers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEphemeralContainers(EphemeralContainer ... items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        for (EphemeralContainer item : items) {
            this.ephemeralContainers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEphemeralContainers(Collection<EphemeralContainer> items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        for (EphemeralContainer item : items) {
            this.ephemeralContainers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEphemeralContainers(EphemeralContainer ... items) {
        for (EphemeralContainer item : items) {
            if (this.ephemeralContainers == null) continue;
            this.ephemeralContainers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items) {
        for (EphemeralContainer item : items) {
            if (this.ephemeralContainers == null) continue;
            this.ephemeralContainers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<EphemeralContainer> getEphemeralContainers() {
        return this.ephemeralContainers;
    }

    @Override
    public EphemeralContainer getEphemeralContainer(Integer index) {
        return this.ephemeralContainers.get(index);
    }

    @Override
    public EphemeralContainer getFirstEphemeralContainer() {
        return this.ephemeralContainers.get(0);
    }

    @Override
    public EphemeralContainer getLastEphemeralContainer() {
        return this.ephemeralContainers.get(this.ephemeralContainers.size() - 1);
    }

    @Override
    public EphemeralContainer getMatchingEphemeralContainer(Predicate<EphemeralContainer> predicate) {
        for (EphemeralContainer item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEphemeralContainer(Predicate<EphemeralContainer> predicate) {
        for (EphemeralContainer item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers) {
        if (ephemeralContainers != null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
            for (EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        } else {
            this.ephemeralContainers = null;
        }
        return (A)this;
    }

    @Override
    public A withEphemeralContainers(EphemeralContainer ... ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this.ephemeralContainers.clear();
        }
        if (ephemeralContainers != null) {
            for (EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEphemeralContainers() {
        return this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty();
    }

    @Override
    public A addToHostAliases(Integer index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        this.hostAliases.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHostAliases(Integer index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        this.hostAliases.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        for (HostAlias item : items) {
            this.hostAliases.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        for (HostAlias item : items) {
            this.hostAliases.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostAliases(HostAlias ... items) {
        for (HostAlias item : items) {
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostAliases(Collection<HostAlias> items) {
        for (HostAlias item : items) {
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<HostAlias> getHostAliases() {
        return this.hostAliases;
    }

    @Override
    public HostAlias getHostAlias(Integer index) {
        return this.hostAliases.get(index);
    }

    @Override
    public HostAlias getFirstHostAlias() {
        return this.hostAliases.get(0);
    }

    @Override
    public HostAlias getLastHostAlias() {
        return this.hostAliases.get(this.hostAliases.size() - 1);
    }

    @Override
    public HostAlias getMatchingHostAlias(Predicate<HostAlias> predicate) {
        for (HostAlias item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHostAlias(Predicate<HostAlias> predicate) {
        for (HostAlias item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHostAliases(List<HostAlias> hostAliases) {
        if (hostAliases != null) {
            this.hostAliases = new ArrayList<HostAlias>();
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        } else {
            this.hostAliases = null;
        }
        return (A)this;
    }

    @Override
    public A withHostAliases(HostAlias ... hostAliases) {
        if (this.hostAliases != null) {
            this.hostAliases.clear();
        }
        if (hostAliases != null) {
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostAliases() {
        return this.hostAliases != null && !this.hostAliases.isEmpty();
    }

    @Override
    public Boolean getHostIPC() {
        return this.hostIPC;
    }

    @Override
    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return (A)this;
    }

    @Override
    public Boolean hasHostIPC() {
        return this.hostIPC != null;
    }

    @Override
    public Boolean getHostNetwork() {
        return this.hostNetwork;
    }

    @Override
    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    @Override
    public Boolean getHostPID() {
        return this.hostPID;
    }

    @Override
    public A withHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return (A)this;
    }

    @Override
    public Boolean hasHostPID() {
        return this.hostPID != null;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    @Deprecated
    public A withNewHostname(String arg0) {
        return this.withHostname(new String(arg0));
    }

    @Override
    public A addToImagePullSecrets(Integer index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
        }
        this.imagePullSecrets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToImagePullSecrets(Integer index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
        }
        this.imagePullSecrets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
        }
        for (LocalObjectReference item : items) {
            this.imagePullSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
        }
        for (LocalObjectReference item : items) {
            this.imagePullSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    @Override
    public LocalObjectReference getImagePullSecret(Integer index) {
        return this.imagePullSecrets.get(index);
    }

    @Override
    public LocalObjectReference getFirstImagePullSecret() {
        return this.imagePullSecrets.get(0);
    }

    @Override
    public LocalObjectReference getLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1);
    }

    @Override
    public LocalObjectReference getMatchingImagePullSecret(Predicate<LocalObjectReference> predicate) {
        for (LocalObjectReference item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReference> predicate) {
        for (LocalObjectReference item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)this;
    }

    @Override
    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
        }
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    @Override
    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    @Override
    public A addToInitContainers(Integer index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get((Object)"initContainers").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"initContainers").size(), builder);
        this.initContainers.add(index >= 0 ? index.intValue() : this.initContainers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInitContainers(Integer index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"initContainers").size()) {
            this._visitables.get((Object)"initContainers").add(builder);
        } else {
            this._visitables.get((Object)"initContainers").set(index, builder);
        }
        if (index < 0 || index >= this.initContainers.size()) {
            this.initContainers.add(builder);
        } else {
            this.initContainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainers(Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.initContainers.iterator();
        List visitables = this._visitables.get((Object)"initContainers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Container> getInitContainers() {
        return RevisionSpecFluentImpl.build(this.initContainers);
    }

    @Override
    public List<Container> buildInitContainers() {
        return RevisionSpecFluentImpl.build(this.initContainers);
    }

    @Override
    public Container buildInitContainer(Integer index) {
        return this.initContainers.get(index).build();
    }

    @Override
    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    @Override
    public Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    @Override
    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInitContainers(List<Container> initContainers) {
        if (this.initContainers != null) {
            this._visitables.get((Object)"initContainers").removeAll(this.initContainers);
        }
        if (initContainers != null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        } else {
            this.initContainers = null;
        }
        return (A)this;
    }

    @Override
    public A withInitContainers(Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
        }
        if (initContainers != null) {
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    @Override
    public RevisionSpecFluent.InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNestedImpl();
    }

    @Override
    public RevisionSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNestedImpl(-1, item);
    }

    @Override
    public RevisionSpecFluent.InitContainersNested<A> setNewInitContainerLike(Integer index, Container item) {
        return new InitContainersNestedImpl(index, item);
    }

    @Override
    public RevisionSpecFluent.InitContainersNested<A> editInitContainer(Integer index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public RevisionSpecFluent.InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    @Override
    public RevisionSpecFluent.InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public RevisionSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.test(this.initContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    @Override
    @Deprecated
    public A withNewNodeName(String arg0) {
        return this.withNodeName(new String(arg0));
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    public A addToOverhead(String key, Quantity value) {
        if (this.overhead == null && key != null && value != null) {
            this.overhead = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.overhead.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToOverhead(Map<String, Quantity> map) {
        if (this.overhead == null && map != null) {
            this.overhead = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.overhead.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromOverhead(String key) {
        if (this.overhead == null) {
            return (A)this;
        }
        if (key != null && this.overhead != null) {
            this.overhead.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromOverhead(Map<String, Quantity> map) {
        if (this.overhead == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.overhead == null) continue;
                this.overhead.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getOverhead() {
        return this.overhead;
    }

    @Override
    public <K, V> A withOverhead(Map<String, Quantity> overhead) {
        this.overhead = overhead == null ? null : new LinkedHashMap<String, Quantity>(overhead);
        return (A)this;
    }

    @Override
    public Boolean hasOverhead() {
        return this.overhead != null;
    }

    @Override
    public String getPreemptionPolicy() {
        return this.preemptionPolicy;
    }

    @Override
    public A withPreemptionPolicy(String preemptionPolicy) {
        this.preemptionPolicy = preemptionPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPreemptionPolicy() {
        return this.preemptionPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewPreemptionPolicy(String arg0) {
        return this.withPreemptionPolicy(new String(arg0));
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)this;
    }

    @Override
    public Boolean hasPriority() {
        return this.priority != null;
    }

    @Override
    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    @Override
    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)this;
    }

    @Override
    public Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    @Override
    @Deprecated
    public A withNewPriorityClassName(String arg0) {
        return this.withPriorityClassName(new String(arg0));
    }

    @Override
    public A addToReadinessGates(Integer index, PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
        }
        this.readinessGates.add(index, item);
        return (A)this;
    }

    @Override
    public A setToReadinessGates(Integer index, PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
        }
        this.readinessGates.set(index, item);
        return (A)this;
    }

    @Override
    public A addToReadinessGates(PodReadinessGate ... items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
        }
        for (PodReadinessGate item : items) {
            this.readinessGates.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToReadinessGates(Collection<PodReadinessGate> items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
        }
        for (PodReadinessGate item : items) {
            this.readinessGates.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromReadinessGates(PodReadinessGate ... items) {
        for (PodReadinessGate item : items) {
            if (this.readinessGates == null) continue;
            this.readinessGates.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromReadinessGates(Collection<PodReadinessGate> items) {
        for (PodReadinessGate item : items) {
            if (this.readinessGates == null) continue;
            this.readinessGates.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<PodReadinessGate> getReadinessGates() {
        return this.readinessGates;
    }

    @Override
    public PodReadinessGate getReadinessGate(Integer index) {
        return this.readinessGates.get(index);
    }

    @Override
    public PodReadinessGate getFirstReadinessGate() {
        return this.readinessGates.get(0);
    }

    @Override
    public PodReadinessGate getLastReadinessGate() {
        return this.readinessGates.get(this.readinessGates.size() - 1);
    }

    @Override
    public PodReadinessGate getMatchingReadinessGate(Predicate<PodReadinessGate> predicate) {
        for (PodReadinessGate item : this.readinessGates) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingReadinessGate(Predicate<PodReadinessGate> predicate) {
        for (PodReadinessGate item : this.readinessGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withReadinessGates(List<PodReadinessGate> readinessGates) {
        if (readinessGates != null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
            for (PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        } else {
            this.readinessGates = null;
        }
        return (A)this;
    }

    @Override
    public A withReadinessGates(PodReadinessGate ... readinessGates) {
        if (this.readinessGates != null) {
            this.readinessGates.clear();
        }
        if (readinessGates != null) {
            for (PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessGates() {
        return this.readinessGates != null && !this.readinessGates.isEmpty();
    }

    @Override
    public A addNewReadinessGate(String conditionType) {
        return this.addToReadinessGates(new PodReadinessGate(conditionType));
    }

    @Override
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    @Override
    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewRestartPolicy(String arg0) {
        return this.withRestartPolicy(new String(arg0));
    }

    @Override
    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    @Override
    public A withRuntimeClassName(String runtimeClassName) {
        this.runtimeClassName = runtimeClassName;
        return (A)this;
    }

    @Override
    public Boolean hasRuntimeClassName() {
        return this.runtimeClassName != null;
    }

    @Override
    @Deprecated
    public A withNewRuntimeClassName(String arg0) {
        return this.withRuntimeClassName(new String(arg0));
    }

    @Override
    public String getSchedulerName() {
        return this.schedulerName;
    }

    @Override
    public A withSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
        return (A)this;
    }

    @Override
    public Boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    @Override
    @Deprecated
    public A withNewSchedulerName(String arg0) {
        return this.withSchedulerName(new String(arg0));
    }

    @Override
    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public A withSecurityContext(PodSecurityContext securityContext) {
        this.securityContext = securityContext;
        return (A)this;
    }

    @Override
    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    @Override
    @Deprecated
    public A withNewServiceAccount(String arg0) {
        return this.withServiceAccount(new String(arg0));
    }

    @Override
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @Override
    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    @Override
    @Deprecated
    public A withNewServiceAccountName(String arg0) {
        return this.withServiceAccountName(new String(arg0));
    }

    @Override
    public Boolean getSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN;
    }

    @Override
    public A withSetHostnameAsFQDN(Boolean setHostnameAsFQDN) {
        this.setHostnameAsFQDN = setHostnameAsFQDN;
        return (A)this;
    }

    @Override
    public Boolean hasSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN != null;
    }

    @Override
    public Boolean getShareProcessNamespace() {
        return this.shareProcessNamespace;
    }

    @Override
    public A withShareProcessNamespace(Boolean shareProcessNamespace) {
        this.shareProcessNamespace = shareProcessNamespace;
        return (A)this;
    }

    @Override
    public Boolean hasShareProcessNamespace() {
        return this.shareProcessNamespace != null;
    }

    @Override
    public String getSubdomain() {
        return this.subdomain;
    }

    @Override
    public A withSubdomain(String subdomain) {
        this.subdomain = subdomain;
        return (A)this;
    }

    @Override
    public Boolean hasSubdomain() {
        return this.subdomain != null;
    }

    @Override
    @Deprecated
    public A withNewSubdomain(String arg0) {
        return this.withSubdomain(new String(arg0));
    }

    @Override
    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    @Override
    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds != null;
    }

    @Override
    public Long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    public A withTimeoutSeconds(Long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    @Override
    public A addToTolerations(Integer index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTolerations(Integer index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Override
    public Toleration getToleration(Integer index) {
        return this.tolerations.get(index);
    }

    @Override
    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    @Override
    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    @Override
    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    @Override
    public A addToTopologySpreadConstraints(Integer index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTopologySpreadConstraints(Integer index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        for (TopologySpreadConstraint item : items) {
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        for (TopologySpreadConstraint item : items) {
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints;
    }

    @Override
    public TopologySpreadConstraint getTopologySpreadConstraint(Integer index) {
        return this.topologySpreadConstraints.get(index);
    }

    @Override
    public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0);
    }

    @Override
    public TopologySpreadConstraint getLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1);
    }

    @Override
    public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)this;
    }

    @Override
    public A withTopologySpreadConstraints(TopologySpreadConstraint ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
        }
        if (topologySpreadConstraints != null) {
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    @Override
    public A addToVolumes(Integer index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        this._visitables.get((Object)"volumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"volumes").size(), builder);
        this.volumes.add(index >= 0 ? index.intValue() : this.volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumes(Integer index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"volumes").size()) {
            this._visitables.get((Object)"volumes").add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
        }
        if (index < 0 || index >= this.volumes.size()) {
            this.volumes.add(builder);
        } else {
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<VolumeBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            VolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Volume> getVolumes() {
        return RevisionSpecFluentImpl.build(this.volumes);
    }

    @Override
    public List<Volume> buildVolumes() {
        return RevisionSpecFluentImpl.build(this.volumes);
    }

    @Override
    public Volume buildVolume(Integer index) {
        return this.volumes.get(index).build();
    }

    @Override
    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    @Override
    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    @Override
    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<VolumeBuilder>();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public RevisionSpecFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public RevisionSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    @Override
    public RevisionSpecFluent.VolumesNested<A> setNewVolumeLike(Integer index, Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    @Override
    public RevisionSpecFluent.VolumesNested<A> editVolume(Integer index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public RevisionSpecFluent.VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    @Override
    public RevisionSpecFluent.VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public RevisionSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevisionSpecFluentImpl that = (RevisionSpecFluentImpl)o;
        if (this.activeDeadlineSeconds != null ? !this.activeDeadlineSeconds.equals(that.activeDeadlineSeconds) : that.activeDeadlineSeconds != null) {
            return false;
        }
        if (this.affinity != null ? !this.affinity.equals((Object)that.affinity) : that.affinity != null) {
            return false;
        }
        if (this.automountServiceAccountToken != null ? !this.automountServiceAccountToken.equals(that.automountServiceAccountToken) : that.automountServiceAccountToken != null) {
            return false;
        }
        if (this.containerConcurrency != null ? !this.containerConcurrency.equals(that.containerConcurrency) : that.containerConcurrency != null) {
            return false;
        }
        if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) {
            return false;
        }
        if (this.dnsConfig != null ? !this.dnsConfig.equals((Object)that.dnsConfig) : that.dnsConfig != null) {
            return false;
        }
        if (this.dnsPolicy != null ? !this.dnsPolicy.equals(that.dnsPolicy) : that.dnsPolicy != null) {
            return false;
        }
        if (this.enableServiceLinks != null ? !this.enableServiceLinks.equals(that.enableServiceLinks) : that.enableServiceLinks != null) {
            return false;
        }
        if (this.ephemeralContainers != null ? !this.ephemeralContainers.equals(that.ephemeralContainers) : that.ephemeralContainers != null) {
            return false;
        }
        if (this.hostAliases != null ? !this.hostAliases.equals(that.hostAliases) : that.hostAliases != null) {
            return false;
        }
        if (this.hostIPC != null ? !this.hostIPC.equals(that.hostIPC) : that.hostIPC != null) {
            return false;
        }
        if (this.hostNetwork != null ? !this.hostNetwork.equals(that.hostNetwork) : that.hostNetwork != null) {
            return false;
        }
        if (this.hostPID != null ? !this.hostPID.equals(that.hostPID) : that.hostPID != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.overhead != null ? !this.overhead.equals(that.overhead) : that.overhead != null) {
            return false;
        }
        if (this.preemptionPolicy != null ? !this.preemptionPolicy.equals(that.preemptionPolicy) : that.preemptionPolicy != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.priorityClassName != null ? !this.priorityClassName.equals(that.priorityClassName) : that.priorityClassName != null) {
            return false;
        }
        if (this.readinessGates != null ? !this.readinessGates.equals(that.readinessGates) : that.readinessGates != null) {
            return false;
        }
        if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) {
            return false;
        }
        if (this.runtimeClassName != null ? !this.runtimeClassName.equals(that.runtimeClassName) : that.runtimeClassName != null) {
            return false;
        }
        if (this.schedulerName != null ? !this.schedulerName.equals(that.schedulerName) : that.schedulerName != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals((Object)that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.serviceAccountName != null ? !this.serviceAccountName.equals(that.serviceAccountName) : that.serviceAccountName != null) {
            return false;
        }
        if (this.setHostnameAsFQDN != null ? !this.setHostnameAsFQDN.equals(that.setHostnameAsFQDN) : that.setHostnameAsFQDN != null) {
            return false;
        }
        if (this.shareProcessNamespace != null ? !this.shareProcessNamespace.equals(that.shareProcessNamespace) : that.shareProcessNamespace != null) {
            return false;
        }
        if (this.subdomain != null ? !this.subdomain.equals(that.subdomain) : that.subdomain != null) {
            return false;
        }
        if (this.terminationGracePeriodSeconds != null ? !this.terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) : that.terminationGracePeriodSeconds != null) {
            return false;
        }
        if (this.timeoutSeconds != null ? !this.timeoutSeconds.equals(that.timeoutSeconds) : that.timeoutSeconds != null) {
            return false;
        }
        if (this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null) {
            return false;
        }
        if (this.topologySpreadConstraints != null ? !this.topologySpreadConstraints.equals(that.topologySpreadConstraints) : that.topologySpreadConstraints != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.affinity, this.automountServiceAccountToken, this.containerConcurrency, this.containers, this.dnsConfig, this.dnsPolicy, this.enableServiceLinks, this.ephemeralContainers, this.hostAliases, this.hostIPC, this.hostNetwork, this.hostPID, this.hostname, this.imagePullSecrets, this.initContainers, this.nodeName, this.nodeSelector, this.overhead, this.preemptionPolicy, this.priority, this.priorityClassName, this.readinessGates, this.restartPolicy, this.runtimeClassName, this.schedulerName, this.securityContext, this.serviceAccount, this.serviceAccountName, this.setHostnameAsFQDN, this.shareProcessNamespace, this.subdomain, this.terminationGracePeriodSeconds, this.timeoutSeconds, this.tolerations, this.topologySpreadConstraints, this.volumes, super.hashCode());
    }

    public class VolumesNestedImpl<N>
    extends VolumeFluentImpl<RevisionSpecFluent.VolumesNested<N>>
    implements RevisionSpecFluent.VolumesNested<N>,
    Nested<N> {
        VolumeBuilder builder;
        Integer index;

        VolumesNestedImpl(Integer index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder((VolumeFluent)this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new VolumeBuilder((VolumeFluent)this);
        }

        @Override
        public N and() {
            return (N)RevisionSpecFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    public class InitContainersNestedImpl<N>
    extends ContainerFluentImpl<RevisionSpecFluent.InitContainersNested<N>>
    implements RevisionSpecFluent.InitContainersNested<N>,
    Nested<N> {
        ContainerBuilder builder;
        Integer index;

        InitContainersNestedImpl(Integer index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        InitContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder((ContainerFluent)this);
        }

        @Override
        public N and() {
            return (N)RevisionSpecFluentImpl.this.setToInitContainers(this.index, this.builder.build());
        }

        @Override
        public N endInitContainer() {
            return this.and();
        }
    }

    public class ContainersNestedImpl<N>
    extends ContainerFluentImpl<RevisionSpecFluent.ContainersNested<N>>
    implements RevisionSpecFluent.ContainersNested<N>,
    Nested<N> {
        ContainerBuilder builder;
        Integer index;

        ContainersNestedImpl(Integer index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        ContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder((ContainerFluent)this);
        }

        @Override
        public N and() {
            return (N)RevisionSpecFluentImpl.this.setToContainers(this.index, this.builder.build());
        }

        @Override
        public N endContainer() {
            return this.and();
        }
    }
}

