package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ContainerSourceFluent<A extends ContainerSourceFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ContainerSourceFluent.MetadataNested<A> withNewMetadata();
    public ContainerSourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ContainerSourceFluent.MetadataNested<A> editMetadata();
    public ContainerSourceFluent.MetadataNested<A> editOrNewMetadata();
    public ContainerSourceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ContainerSourceSpec getSpec();
    public ContainerSourceSpec buildSpec();
    public A withSpec(ContainerSourceSpec spec);
    public Boolean hasSpec();
    public ContainerSourceFluent.SpecNested<A> withNewSpec();
    public ContainerSourceFluent.SpecNested<A> withNewSpecLike(ContainerSourceSpec item);
    public ContainerSourceFluent.SpecNested<A> editSpec();
    public ContainerSourceFluent.SpecNested<A> editOrNewSpec();
    public ContainerSourceFluent.SpecNested<A> editOrNewSpecLike(ContainerSourceSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public ContainerSourceStatus getStatus();
    public ContainerSourceStatus buildStatus();
    public A withStatus(ContainerSourceStatus status);
    public Boolean hasStatus();
    public ContainerSourceFluent.StatusNested<A> withNewStatus();
    public ContainerSourceFluent.StatusNested<A> withNewStatusLike(ContainerSourceStatus item);
    public ContainerSourceFluent.StatusNested<A> editStatus();
    public ContainerSourceFluent.StatusNested<A> editOrNewStatus();
    public ContainerSourceFluent.StatusNested<A> editOrNewStatusLike(ContainerSourceStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ContainerSourceFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerSourceSpecFluent<ContainerSourceFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerSourceStatusFluent<ContainerSourceFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
