package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ApiServerSourceListFluent<A extends ApiServerSourceListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ApiServerSource item);
    public A setToItems(int index,ApiServerSource item);
    public A addToItems(ApiServerSource... items);
    public A addAllToItems(Collection<ApiServerSource> items);
    public A removeFromItems(ApiServerSource... items);
    public A removeAllFromItems(Collection<ApiServerSource> items);
    public A removeMatchingFromItems(Predicate<ApiServerSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ApiServerSource> getItems();
    public List<ApiServerSource> buildItems();
    public ApiServerSource buildItem(int index);
    public ApiServerSource buildFirstItem();
    public ApiServerSource buildLastItem();
    public ApiServerSource buildMatchingItem(Predicate<ApiServerSourceBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ApiServerSourceBuilder> predicate);
    public A withItems(List<ApiServerSource> items);
    public A withItems(ApiServerSource... items);
    public Boolean hasItems();
    public ApiServerSourceListFluent.ItemsNested<A> addNewItem();
    public ApiServerSourceListFluent.ItemsNested<A> addNewItemLike(ApiServerSource item);
    public ApiServerSourceListFluent.ItemsNested<A> setNewItemLike(int index,ApiServerSource item);
    public ApiServerSourceListFluent.ItemsNested<A> editItem(int index);
    public ApiServerSourceListFluent.ItemsNested<A> editFirstItem();
    public ApiServerSourceListFluent.ItemsNested<A> editLastItem();
    public ApiServerSourceListFluent.ItemsNested<A> editMatchingItem(Predicate<ApiServerSourceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ApiServerSourceFluent<ApiServerSourceListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
