package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaSASLSpecBuilder extends KafkaSASLSpecFluentImpl<KafkaSASLSpecBuilder> implements VisitableBuilder<KafkaSASLSpec,KafkaSASLSpecBuilder> {

    KafkaSASLSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaSASLSpecBuilder() {
        this(true);
    }

    public KafkaSASLSpecBuilder(Boolean validationEnabled) {
        this(new KafkaSASLSpec(), validationEnabled);
    }

    public KafkaSASLSpecBuilder(KafkaSASLSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaSASLSpecBuilder(KafkaSASLSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaSASLSpec(), validationEnabled);
    }

    public KafkaSASLSpecBuilder(KafkaSASLSpecFluent<?> fluent,KafkaSASLSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaSASLSpecBuilder(KafkaSASLSpecFluent<?> fluent,KafkaSASLSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withEnable(instance.getEnable()); 
        fluent.withPassword(instance.getPassword()); 
        fluent.withUser(instance.getUser()); 
        this.validationEnabled = validationEnabled; 
    }

    public KafkaSASLSpecBuilder(KafkaSASLSpec instance) {
        this(instance,true);
    }

    public KafkaSASLSpecBuilder(KafkaSASLSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withEnable(instance.getEnable()); 
        this.withPassword(instance.getPassword()); 
        this.withUser(instance.getUser()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.EditableKafkaSASLSpec build() {
        EditableKafkaSASLSpec buildable = new EditableKafkaSASLSpec(fluent.isEnable(),fluent.getPassword(),fluent.getUser());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaSASLSpecBuilder that = (KafkaSASLSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
