package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaNetSpecBuilder extends KafkaNetSpecFluentImpl<KafkaNetSpecBuilder> implements VisitableBuilder<KafkaNetSpec,KafkaNetSpecBuilder> {

    KafkaNetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaNetSpecBuilder() {
        this(true);
    }

    public KafkaNetSpecBuilder(Boolean validationEnabled) {
        this(new KafkaNetSpec(), validationEnabled);
    }

    public KafkaNetSpecBuilder(KafkaNetSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaNetSpecBuilder(KafkaNetSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaNetSpec(), validationEnabled);
    }

    public KafkaNetSpecBuilder(KafkaNetSpecFluent<?> fluent,KafkaNetSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaNetSpecBuilder(KafkaNetSpecFluent<?> fluent,KafkaNetSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSasl(instance.getSasl()); 
        fluent.withTls(instance.getTls()); 
        this.validationEnabled = validationEnabled; 
    }

    public KafkaNetSpecBuilder(KafkaNetSpec instance) {
        this(instance,true);
    }

    public KafkaNetSpecBuilder(KafkaNetSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withSasl(instance.getSasl()); 
        this.withTls(instance.getTls()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.EditableKafkaNetSpec build() {
        EditableKafkaNetSpec buildable = new EditableKafkaNetSpec(fluent.getSasl(),fluent.getTls());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaNetSpecBuilder that = (KafkaNetSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
