package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SinkBindingListBuilder extends SinkBindingListFluentImpl<SinkBindingListBuilder> implements VisitableBuilder<SinkBindingList,SinkBindingListBuilder> {

    SinkBindingListFluent<?> fluent;
    Boolean validationEnabled;

    public SinkBindingListBuilder() {
        this(true);
    }

    public SinkBindingListBuilder(Boolean validationEnabled) {
        this(new SinkBindingList(), validationEnabled);
    }

    public SinkBindingListBuilder(SinkBindingListFluent<?> fluent) {
        this(fluent, true);
    }

    public SinkBindingListBuilder(SinkBindingListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SinkBindingList(), validationEnabled);
    }

    public SinkBindingListBuilder(SinkBindingListFluent<?> fluent,SinkBindingList instance) {
        this(fluent, instance, true);
    }

    public SinkBindingListBuilder(SinkBindingListFluent<?> fluent,SinkBindingList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public SinkBindingListBuilder(SinkBindingList instance) {
        this(instance,true);
    }

    public SinkBindingListBuilder(SinkBindingList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.sources.v1beta1.EditableSinkBindingList build() {
        EditableSinkBindingList buildable = new EditableSinkBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SinkBindingListBuilder that = (SinkBindingListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
