package io.fabric8.knative.sources.v1beta1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import java.lang.Deprecated;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import java.lang.Boolean;

public class ContainerSourceSpecFluentImpl<A extends ContainerSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ContainerSourceSpecFluent<A> {

    private CloudEventOverridesBuilder ceOverrides;
    private DestinationBuilder sink;
    private PodTemplateSpec template;

    public ContainerSourceSpecFluentImpl() {
    }

    public ContainerSourceSpecFluentImpl(ContainerSourceSpec instance) {
        this.withCeOverrides(instance.getCeOverrides()); 
        this.withSink(instance.getSink()); 
        this.withTemplate(instance.getTemplate()); 
    }

    
/**
 * This method has been deprecated, please use method buildCeOverrides instead.
 * @return The buildable object.
 */
@Deprecated public CloudEventOverrides getCeOverrides() {
        return this.ceOverrides!=null?this.ceOverrides.build():null;
    }

    public CloudEventOverrides buildCeOverrides() {
        return this.ceOverrides!=null?this.ceOverrides.build():null;
    }

    public A withCeOverrides(CloudEventOverrides ceOverrides) {
        _visitables.get("ceOverrides").remove(this.ceOverrides);
        if (ceOverrides!=null){ this.ceOverrides= new CloudEventOverridesBuilder(ceOverrides); _visitables.get("ceOverrides").add(this.ceOverrides);} return (A) this;
    }

    public Boolean hasCeOverrides() {
        return this.ceOverrides != null;
    }

    public ContainerSourceSpecFluent.CeOverridesNested<A> withNewCeOverrides() {
        return new CeOverridesNestedImpl();
    }

    public ContainerSourceSpecFluent.CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
        return new CeOverridesNestedImpl(item);
    }

    public ContainerSourceSpecFluent.CeOverridesNested<A> editCeOverrides() {
        return withNewCeOverridesLike(getCeOverrides());
    }

    public ContainerSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverrides() {
        return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): new CloudEventOverridesBuilder().build());
    }

    public ContainerSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
        return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@Deprecated public Destination getSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public Destination buildSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public A withSink(Destination sink) {
        _visitables.get("sink").remove(this.sink);
        if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} return (A) this;
    }

    public Boolean hasSink() {
        return this.sink != null;
    }

    public ContainerSourceSpecFluent.SinkNested<A> withNewSink() {
        return new SinkNestedImpl();
    }

    public ContainerSourceSpecFluent.SinkNested<A> withNewSinkLike(Destination item) {
        return new SinkNestedImpl(item);
    }

    public ContainerSourceSpecFluent.SinkNested<A> editSink() {
        return withNewSinkLike(getSink());
    }

    public ContainerSourceSpecFluent.SinkNested<A> editOrNewSink() {
        return withNewSinkLike(getSink() != null ? getSink(): new DestinationBuilder().build());
    }

    public ContainerSourceSpecFluent.SinkNested<A> editOrNewSinkLike(Destination item) {
        return withNewSinkLike(getSink() != null ? getSink(): item);
    }

    public PodTemplateSpec getTemplate() {
        return this.template;
    }

    public A withTemplate(PodTemplateSpec template) {
        this.template=template; return (A) this;
    }

    public Boolean hasTemplate() {
        return this.template != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ContainerSourceSpecFluentImpl that = (ContainerSourceSpecFluentImpl) o;
        if (ceOverrides != null ? !ceOverrides.equals(that.ceOverrides) :that.ceOverrides != null) return false;
        if (sink != null ? !sink.equals(that.sink) :that.sink != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ceOverrides,  sink,  template,  super.hashCode());
    }

    public class CeOverridesNestedImpl<N> extends CloudEventOverridesFluentImpl<ContainerSourceSpecFluent.CeOverridesNested<N>> implements ContainerSourceSpecFluent.CeOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CloudEventOverridesBuilder builder;

            CeOverridesNestedImpl(CloudEventOverrides item) {
                this.builder = new CloudEventOverridesBuilder(this, item);
                        
            }

            CeOverridesNestedImpl() {
                this.builder = new CloudEventOverridesBuilder(this);
                        
            }

            public N and() {
                return (N) ContainerSourceSpecFluentImpl.this.withCeOverrides(builder.build());
            }

            public N endCeOverrides() {
                return and();
            }
    }


    public class SinkNestedImpl<N> extends DestinationFluentImpl<ContainerSourceSpecFluent.SinkNested<N>> implements ContainerSourceSpecFluent.SinkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DestinationBuilder builder;

            SinkNestedImpl(Destination item) {
                this.builder = new DestinationBuilder(this, item);
                        
            }

            SinkNestedImpl() {
                this.builder = new DestinationBuilder(this);
                        
            }

            public N and() {
                return (N) ContainerSourceSpecFluentImpl.this.withSink(builder.build());
            }

            public N endSink() {
                return and();
            }
    }


}
