package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

public interface APIVersionKindSelectorFluent<A extends APIVersionKindSelectorFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector();
    public LabelSelector buildSelector();
    public A withSelector(LabelSelector selector);
    public Boolean hasSelector();
    public APIVersionKindSelectorFluent.SelectorNested<A> withNewSelector();
    public APIVersionKindSelectorFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public APIVersionKindSelectorFluent.SelectorNested<A> editSelector();
    public APIVersionKindSelectorFluent.SelectorNested<A> editOrNewSelector();
    public APIVersionKindSelectorFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<APIVersionKindSelectorFluent.SelectorNested<N>> {

            public N and();
            public N endSelector();    }


}
