package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceSpecBuilder extends ServiceSpecFluentImpl<ServiceSpecBuilder> implements VisitableBuilder<ServiceSpec,ServiceSpecBuilder> {

    ServiceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceSpecBuilder() {
        this(true);
    }

    public ServiceSpecBuilder(Boolean validationEnabled) {
        this(new ServiceSpec(), validationEnabled);
    }

    public ServiceSpecBuilder(ServiceSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceSpecBuilder(ServiceSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ServiceSpec(), validationEnabled);
    }

    public ServiceSpecBuilder(ServiceSpecFluent<?> fluent,ServiceSpec instance) {
        this(fluent, instance, true);
    }

    public ServiceSpecBuilder(ServiceSpecFluent<?> fluent,ServiceSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTemplate(instance.getTemplate()); 
        fluent.withTraffic(instance.getTraffic()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceSpecBuilder(ServiceSpec instance) {
        this(instance,true);
    }

    public ServiceSpecBuilder(ServiceSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withTemplate(instance.getTemplate()); 
        this.withTraffic(instance.getTraffic()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.serving.v1.EditableServiceSpec build() {
        EditableServiceSpec buildable = new EditableServiceSpec(fluent.getTemplate(),fluent.getTraffic());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceSpecBuilder that = (ServiceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
