package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BrokerStatusBuilder extends BrokerStatusFluentImpl<BrokerStatusBuilder> implements VisitableBuilder<BrokerStatus,BrokerStatusBuilder> {

    BrokerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public BrokerStatusBuilder() {
        this(true);
    }

    public BrokerStatusBuilder(Boolean validationEnabled) {
        this(new BrokerStatus(), validationEnabled);
    }

    public BrokerStatusBuilder(BrokerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public BrokerStatusBuilder(BrokerStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new BrokerStatus(), validationEnabled);
    }

    public BrokerStatusBuilder(BrokerStatusFluent<?> fluent,BrokerStatus instance) {
        this(fluent, instance, true);
    }

    public BrokerStatusBuilder(BrokerStatusFluent<?> fluent,BrokerStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAddress(instance.getAddress()); 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        this.validationEnabled = validationEnabled; 
    }

    public BrokerStatusBuilder(BrokerStatus instance) {
        this(instance,true);
    }

    public BrokerStatusBuilder(BrokerStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAddress(instance.getAddress()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.v1.EditableBrokerStatus build() {
        EditableBrokerStatus buildable = new EditableBrokerStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getConditions(),fluent.getObservedGeneration());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BrokerStatusBuilder that = (BrokerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
