package io.fabric8.knative.eventing.contrib.prometheus.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PrometheusSourceStatusBuilder extends PrometheusSourceStatusFluentImpl<PrometheusSourceStatusBuilder> implements VisitableBuilder<PrometheusSourceStatus,PrometheusSourceStatusBuilder> {

    PrometheusSourceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public PrometheusSourceStatusBuilder() {
        this(true);
    }

    public PrometheusSourceStatusBuilder(Boolean validationEnabled) {
        this(new PrometheusSourceStatus(), validationEnabled);
    }

    public PrometheusSourceStatusBuilder(PrometheusSourceStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public PrometheusSourceStatusBuilder(PrometheusSourceStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PrometheusSourceStatus(), validationEnabled);
    }

    public PrometheusSourceStatusBuilder(PrometheusSourceStatusFluent<?> fluent,PrometheusSourceStatus instance) {
        this(fluent, instance, true);
    }

    public PrometheusSourceStatusBuilder(PrometheusSourceStatusFluent<?> fluent,PrometheusSourceStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withCeAttributes(instance.getCeAttributes()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }

    public PrometheusSourceStatusBuilder(PrometheusSourceStatus instance) {
        this(instance,true);
    }

    public PrometheusSourceStatusBuilder(PrometheusSourceStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withCeAttributes(instance.getCeAttributes()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.EditablePrometheusSourceStatus build() {
        EditablePrometheusSourceStatus buildable = new EditablePrometheusSourceStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PrometheusSourceStatusBuilder that = (PrometheusSourceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
