package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KafkaSourceListFluent<A extends KafkaSourceListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,KafkaSource item);
    public A setToItems(int index,KafkaSource item);
    public A addToItems(KafkaSource... items);
    public A addAllToItems(Collection<KafkaSource> items);
    public A removeFromItems(KafkaSource... items);
    public A removeAllFromItems(Collection<KafkaSource> items);
    public A removeMatchingFromItems(Predicate<KafkaSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<KafkaSource> getItems();
    public List<KafkaSource> buildItems();
    public KafkaSource buildItem(int index);
    public KafkaSource buildFirstItem();
    public KafkaSource buildLastItem();
    public KafkaSource buildMatchingItem(Predicate<KafkaSourceBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<KafkaSourceBuilder> predicate);
    public A withItems(List<KafkaSource> items);
    public A withItems(KafkaSource... items);
    public Boolean hasItems();
    public KafkaSourceListFluent.ItemsNested<A> addNewItem();
    public KafkaSourceListFluent.ItemsNested<A> addNewItemLike(KafkaSource item);
    public KafkaSourceListFluent.ItemsNested<A> setNewItemLike(int index,KafkaSource item);
    public KafkaSourceListFluent.ItemsNested<A> editItem(int index);
    public KafkaSourceListFluent.ItemsNested<A> editFirstItem();
    public KafkaSourceListFluent.ItemsNested<A> editLastItem();
    public KafkaSourceListFluent.ItemsNested<A> editMatchingItem(Predicate<KafkaSourceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaSourceFluent<KafkaSourceListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
