package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface GitLabBindingFluent<A extends GitLabBindingFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public GitLabBindingFluent.MetadataNested<A> withNewMetadata();
    public GitLabBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public GitLabBindingFluent.MetadataNested<A> editMetadata();
    public GitLabBindingFluent.MetadataNested<A> editOrNewMetadata();
    public GitLabBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public GitLabBindingSpec getSpec();
    public GitLabBindingSpec buildSpec();
    public A withSpec(GitLabBindingSpec spec);
    public Boolean hasSpec();
    public GitLabBindingFluent.SpecNested<A> withNewSpec();
    public GitLabBindingFluent.SpecNested<A> withNewSpecLike(GitLabBindingSpec item);
    public GitLabBindingFluent.SpecNested<A> editSpec();
    public GitLabBindingFluent.SpecNested<A> editOrNewSpec();
    public GitLabBindingFluent.SpecNested<A> editOrNewSpecLike(GitLabBindingSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public GitLabBindingStatus getStatus();
    public GitLabBindingStatus buildStatus();
    public A withStatus(GitLabBindingStatus status);
    public Boolean hasStatus();
    public GitLabBindingFluent.StatusNested<A> withNewStatus();
    public GitLabBindingFluent.StatusNested<A> withNewStatusLike(GitLabBindingStatus item);
    public GitLabBindingFluent.StatusNested<A> editStatus();
    public GitLabBindingFluent.StatusNested<A> editOrNewStatus();
    public GitLabBindingFluent.StatusNested<A> editOrNewStatusLike(GitLabBindingStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<GitLabBindingFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GitLabBindingSpecFluent<GitLabBindingFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GitLabBindingStatusFluent<GitLabBindingFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
