package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitHubBindingStatusBuilder extends GitHubBindingStatusFluentImpl<GitHubBindingStatusBuilder> implements VisitableBuilder<GitHubBindingStatus,GitHubBindingStatusBuilder> {

    GitHubBindingStatusFluent<?> fluent;
    Boolean validationEnabled;

    public GitHubBindingStatusBuilder() {
        this(true);
    }

    public GitHubBindingStatusBuilder(Boolean validationEnabled) {
        this(new GitHubBindingStatus(), validationEnabled);
    }

    public GitHubBindingStatusBuilder(GitHubBindingStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public GitHubBindingStatusBuilder(GitHubBindingStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new GitHubBindingStatus(), validationEnabled);
    }

    public GitHubBindingStatusBuilder(GitHubBindingStatusFluent<?> fluent,GitHubBindingStatus instance) {
        this(fluent, instance, true);
    }

    public GitHubBindingStatusBuilder(GitHubBindingStatusFluent<?> fluent,GitHubBindingStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withCeAttributes(instance.getCeAttributes()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }

    public GitHubBindingStatusBuilder(GitHubBindingStatus instance) {
        this(instance,true);
    }

    public GitHubBindingStatusBuilder(GitHubBindingStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withCeAttributes(instance.getCeAttributes()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.EditableGitHubBindingStatus build() {
        EditableGitHubBindingStatus buildable = new EditableGitHubBindingStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitHubBindingStatusBuilder that = (GitHubBindingStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
