package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SinkBindingStatusBuilder extends SinkBindingStatusFluentImpl<SinkBindingStatusBuilder> implements VisitableBuilder<SinkBindingStatus,SinkBindingStatusBuilder> {

    SinkBindingStatusFluent<?> fluent;
    Boolean validationEnabled;

    public SinkBindingStatusBuilder() { 
        this(true);
    }


    public SinkBindingStatusBuilder(Boolean validationEnabled) { 
        this(new SinkBindingStatus(), validationEnabled);
    }


    public SinkBindingStatusBuilder(SinkBindingStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public SinkBindingStatusBuilder(SinkBindingStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new SinkBindingStatus(), validationEnabled);
    }


    public SinkBindingStatusBuilder(SinkBindingStatusFluent<?> fluent,SinkBindingStatus instance) { 
        this(fluent, instance, true);
    }


    public SinkBindingStatusBuilder(SinkBindingStatusFluent<?> fluent,SinkBindingStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withCeAttributes(instance.getCeAttributes()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }


    public SinkBindingStatusBuilder(SinkBindingStatus instance) { 
        this(instance,true);
    }


    public SinkBindingStatusBuilder(SinkBindingStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withCeAttributes(instance.getCeAttributes()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.sources.v1beta1.EditableSinkBindingStatus build() {
        EditableSinkBindingStatus buildable = new EditableSinkBindingStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SinkBindingStatusBuilder that = (SinkBindingStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
