package io.fabric8.knative.sources.v1beta1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributesBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributesFluentImpl;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class PingSourceStatusFluentImpl<A extends PingSourceStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PingSourceStatusFluent<A> {

    private Map<String,String> annotations;
    private List<CloudEventAttributesBuilder> ceAttributes;
    private List<ConditionBuilder> conditions;
    private Long observedGeneration;
    private String sinkUri;

    public PingSourceStatusFluentImpl() { 
    }


    public PingSourceStatusFluentImpl(PingSourceStatus instance) { 
        this.withAnnotations(instance.getAnnotations()); 
        this.withCeAttributes(instance.getCeAttributes()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSinkUri(instance.getSinkUri()); 
    }


    public A addToAnnotations(String key,String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(Map<String,String> map) {
        if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(Map<String,String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAnnotations() {
        return this.annotations;
    }

    public A withAnnotations(Map<String,String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap<String,String>(annotations);} return (A) this;
    }

    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToCeAttributes(int index,CloudEventAttributes item) {
        if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
        CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").add(index >= 0 ? index : _visitables.get("ceAttributes").size(), builder);this.ceAttributes.add(index >= 0 ? index : ceAttributes.size(), builder); return (A)this;
    }

    public A setToCeAttributes(int index,CloudEventAttributes item) {
        if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
        CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
        if (index < 0 || index >= _visitables.get("ceAttributes").size()) { _visitables.get("ceAttributes").add(builder); } else { _visitables.get("ceAttributes").set(index, builder);}
        if (index < 0 || index >= ceAttributes.size()) { ceAttributes.add(builder); } else { ceAttributes.set(index, builder);}
         return (A)this;
    }

    public A addToCeAttributes(CloudEventAttributes... items) {
        if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
        for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").add(builder);this.ceAttributes.add(builder);} return (A)this;
    }

    public A addAllToCeAttributes(Collection<CloudEventAttributes> items) {
        if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
        for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").add(builder);this.ceAttributes.add(builder);} return (A)this;
    }

    public A removeFromCeAttributes(CloudEventAttributes... items) {
        for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").remove(builder);if (this.ceAttributes != null) {this.ceAttributes.remove(builder);}} return (A)this;
    }

    public A removeAllFromCeAttributes(Collection<CloudEventAttributes> items) {
        for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").remove(builder);if (this.ceAttributes != null) {this.ceAttributes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromCeAttributes(Predicate<CloudEventAttributesBuilder> predicate) {
        if (ceAttributes == null) return (A) this;
        final Iterator<CloudEventAttributesBuilder> each = ceAttributes.iterator();
        final List visitables = _visitables.get("ceAttributes");
        while (each.hasNext()) {
          CloudEventAttributesBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildCeAttributes instead.
 * @return The buildable object.
 */
@Deprecated public List<CloudEventAttributes> getCeAttributes() {
        return build(ceAttributes);
    }

    public List<CloudEventAttributes> buildCeAttributes() {
        return build(ceAttributes);
    }

    public CloudEventAttributes buildCeAttribute(int index) {
        return this.ceAttributes.get(index).build();
    }

    public CloudEventAttributes buildFirstCeAttribute() {
        return this.ceAttributes.get(0).build();
    }

    public CloudEventAttributes buildLastCeAttribute() {
        return this.ceAttributes.get(ceAttributes.size() - 1).build();
    }

    public CloudEventAttributes buildMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
        for (CloudEventAttributesBuilder item: ceAttributes) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
        for (CloudEventAttributesBuilder item: ceAttributes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withCeAttributes(List<CloudEventAttributes> ceAttributes) {
        if (this.ceAttributes != null) { _visitables.get("ceAttributes").removeAll(this.ceAttributes);}
        if (ceAttributes != null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>(); for (CloudEventAttributes item : ceAttributes){this.addToCeAttributes(item);}} else { this.ceAttributes = null;} return (A) this;
    }

    public A withCeAttributes(CloudEventAttributes... ceAttributes) {
        if (this.ceAttributes != null) {this.ceAttributes.clear();}
        if (ceAttributes != null) {for (CloudEventAttributes item :ceAttributes){ this.addToCeAttributes(item);}} return (A) this;
    }

    public Boolean hasCeAttributes() {
        return ceAttributes != null && !ceAttributes.isEmpty();
    }

    public A addNewCeAttribute(String source,String type) {
        return (A)addToCeAttributes(new CloudEventAttributes(source, type));
    }

    public PingSourceStatusFluent.CeAttributesNested<A> addNewCeAttribute() {
        return new CeAttributesNestedImpl();
    }

    public PingSourceStatusFluent.CeAttributesNested<A> addNewCeAttributeLike(CloudEventAttributes item) {
        return new CeAttributesNestedImpl(-1, item);
    }

    public PingSourceStatusFluent.CeAttributesNested<A> setNewCeAttributeLike(int index,CloudEventAttributes item) {
        return new CeAttributesNestedImpl(index, item);
    }

    public PingSourceStatusFluent.CeAttributesNested<A> editCeAttribute(int index) {
        if (ceAttributes.size() <= index) throw new RuntimeException("Can't edit ceAttributes. Index exceeds size.");
        return setNewCeAttributeLike(index, buildCeAttribute(index));
    }

    public PingSourceStatusFluent.CeAttributesNested<A> editFirstCeAttribute() {
        if (ceAttributes.size() == 0) throw new RuntimeException("Can't edit first ceAttributes. The list is empty.");
        return setNewCeAttributeLike(0, buildCeAttribute(0));
    }

    public PingSourceStatusFluent.CeAttributesNested<A> editLastCeAttribute() {
        int index = ceAttributes.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last ceAttributes. The list is empty.");
        return setNewCeAttributeLike(index, buildCeAttribute(index));
    }

    public PingSourceStatusFluent.CeAttributesNested<A> editMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
        int index = -1;
        for (int i=0;i<ceAttributes.size();i++) { 
        if (predicate.test(ceAttributes.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching ceAttributes. No match found.");
        return setNewCeAttributeLike(index, buildCeAttribute(index));
    }

    public A addToConditions(int index,Condition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,Condition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(Condition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(Condition... items) {
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<ConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          ConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions() {
        return build(conditions);
    }

    public List<Condition> buildConditions() {
        return build(conditions);
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<ConditionBuilder>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(Condition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public PingSourceStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public PingSourceStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public PingSourceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public PingSourceStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public PingSourceStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public PingSourceStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public PingSourceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public String getSinkUri() {
        return this.sinkUri;
    }

    public A withSinkUri(String sinkUri) {
        this.sinkUri=sinkUri; return (A) this;
    }

    public Boolean hasSinkUri() {
        return this.sinkUri != null;
    }

    public A withNewSinkUri(String arg1) {
        return (A)withSinkUri(new String(arg1));
    }

    public A withNewSinkUri(StringBuilder arg1) {
        return (A)withSinkUri(new String(arg1));
    }

    public A withNewSinkUri(StringBuffer arg1) {
        return (A)withSinkUri(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PingSourceStatusFluentImpl that = (PingSourceStatusFluentImpl) o;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (ceAttributes != null ? !ceAttributes.equals(that.ceAttributes) :that.ceAttributes != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
        if (sinkUri != null ? !sinkUri.equals(that.sinkUri) :that.sinkUri != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(annotations,  ceAttributes,  conditions,  observedGeneration,  sinkUri,  super.hashCode());
    }

    public class CeAttributesNestedImpl<N> extends CloudEventAttributesFluentImpl<PingSourceStatusFluent.CeAttributesNested<N>> implements PingSourceStatusFluent.CeAttributesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CloudEventAttributesBuilder builder;
        private final int index;

        CeAttributesNestedImpl(int index,CloudEventAttributes item) {
            this.index = index;
            this.builder = new CloudEventAttributesBuilder(this, item);
        }

        CeAttributesNestedImpl() {
            this.index = -1;
            this.builder = new CloudEventAttributesBuilder(this);
        }

        public N and() {
             return (N) PingSourceStatusFluentImpl.this.setToCeAttributes(index,builder.build());
        }

        public N endCeAttribute() {
             return and();
        }
    }


    public class ConditionsNestedImpl<N> extends ConditionFluentImpl<PingSourceStatusFluent.ConditionsNested<N>> implements PingSourceStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index,Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ConditionBuilder(this);
        }

        public N and() {
             return (N) PingSourceStatusFluentImpl.this.setToConditions(index,builder.build());
        }

        public N endCondition() {
             return and();
        }
    }


}
