package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class RevisionTemplateSpecFluentImpl<A extends RevisionTemplateSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RevisionTemplateSpecFluent<A> {

    private ObjectMetaBuilder metadata;
    private RevisionSpecBuilder spec;

    public RevisionTemplateSpecFluentImpl() { 
    }


    public RevisionTemplateSpecFluentImpl(RevisionTemplateSpec instance) { 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
    }


    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public RevisionTemplateSpecFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public RevisionTemplateSpecFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public RevisionTemplateSpecFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public RevisionTemplateSpecFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public RevisionTemplateSpecFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public RevisionSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public RevisionSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(RevisionSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new RevisionSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public RevisionTemplateSpecFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public RevisionTemplateSpecFluent.SpecNested<A> withNewSpecLike(RevisionSpec item) {
        return new SpecNestedImpl(item);
    }

    public RevisionTemplateSpecFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public RevisionTemplateSpecFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new RevisionSpecBuilder().build());
    }

    public RevisionTemplateSpecFluent.SpecNested<A> editOrNewSpecLike(RevisionSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RevisionTemplateSpecFluentImpl that = (RevisionTemplateSpecFluentImpl) o;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(metadata,  spec,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<RevisionTemplateSpecFluent.MetadataNested<N>> implements RevisionTemplateSpecFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        public N and() {
             return (N) RevisionTemplateSpecFluentImpl.this.withMetadata(builder.build());
        }

        public N endMetadata() {
             return and();
        }
    }


    public class SpecNestedImpl<N> extends RevisionSpecFluentImpl<RevisionTemplateSpecFluent.SpecNested<N>> implements RevisionTemplateSpecFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RevisionSpecBuilder builder;

        SpecNestedImpl(RevisionSpec item) {
            this.builder = new RevisionSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new RevisionSpecBuilder(this);
        }

        public N and() {
             return (N) RevisionTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endSpec() {
             return and();
        }
    }


}
