package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;

public class GitHubSourceFluentImpl<A extends GitHubSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GitHubSourceFluent<A> {

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private GitHubSourceSpecBuilder spec;
    private GitHubSourceStatusBuilder status;

    public GitHubSourceFluentImpl() { 
    }


    public GitHubSourceFluentImpl(GitHubSource instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public GitHubSourceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public GitHubSourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public GitHubSourceFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public GitHubSourceFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public GitHubSourceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public GitHubSourceSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public GitHubSourceSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(GitHubSourceSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new GitHubSourceSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public GitHubSourceFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public GitHubSourceFluent.SpecNested<A> withNewSpecLike(GitHubSourceSpec item) {
        return new SpecNestedImpl(item);
    }

    public GitHubSourceFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public GitHubSourceFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new GitHubSourceSpecBuilder().build());
    }

    public GitHubSourceFluent.SpecNested<A> editOrNewSpecLike(GitHubSourceSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public GitHubSourceStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public GitHubSourceStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(GitHubSourceStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new GitHubSourceStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public GitHubSourceFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public GitHubSourceFluent.StatusNested<A> withNewStatusLike(GitHubSourceStatus item) {
        return new StatusNestedImpl(item);
    }

    public GitHubSourceFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public GitHubSourceFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new GitHubSourceStatusBuilder().build());
    }

    public GitHubSourceFluent.StatusNested<A> editOrNewStatusLike(GitHubSourceStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GitHubSourceFluentImpl that = (GitHubSourceFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<GitHubSourceFluent.MetadataNested<N>> implements GitHubSourceFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        public N and() {
             return (N) GitHubSourceFluentImpl.this.withMetadata(builder.build());
        }

        public N endMetadata() {
             return and();
        }
    }


    public class SpecNestedImpl<N> extends GitHubSourceSpecFluentImpl<GitHubSourceFluent.SpecNested<N>> implements GitHubSourceFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GitHubSourceSpecBuilder builder;

        SpecNestedImpl(GitHubSourceSpec item) {
            this.builder = new GitHubSourceSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new GitHubSourceSpecBuilder(this);
        }

        public N and() {
             return (N) GitHubSourceFluentImpl.this.withSpec(builder.build());
        }

        public N endSpec() {
             return and();
        }
    }


    public class StatusNestedImpl<N> extends GitHubSourceStatusFluentImpl<GitHubSourceFluent.StatusNested<N>> implements GitHubSourceFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GitHubSourceStatusBuilder builder;

        StatusNestedImpl(GitHubSourceStatus item) {
            this.builder = new GitHubSourceStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new GitHubSourceStatusBuilder(this);
        }

        public N and() {
             return (N) GitHubSourceFluentImpl.this.withStatus(builder.build());
        }

        public N endStatus() {
             return and();
        }
    }


}
