package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class RevisionStatusFluentImpl<A extends RevisionStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RevisionStatusFluent<A> {

    private Map<String,String> annotations;
    private List<ConditionBuilder> conditions;
    private List<ContainerStatusesBuilder> containerStatuses;
    private String imageDigest;
    private String logUrl;
    private Long observedGeneration;
    private String serviceName;

    public RevisionStatusFluentImpl() { 
    }


    public RevisionStatusFluentImpl(RevisionStatus instance) { 
        this.withAnnotations(instance.getAnnotations()); 
        this.withConditions(instance.getConditions()); 
        this.withContainerStatuses(instance.getContainerStatuses()); 
        this.withImageDigest(instance.getImageDigest()); 
        this.withLogUrl(instance.getLogUrl()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withServiceName(instance.getServiceName()); 
    }


    public A addToAnnotations(String key,String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(Map<String,String> map) {
        if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(Map<String,String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAnnotations() {
        return this.annotations;
    }

    public A withAnnotations(Map<String,String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap<String,String>(annotations);} return (A) this;
    }

    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToConditions(int index,Condition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,Condition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(Condition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(Condition... items) {
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<ConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          ConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions() {
        return build(conditions);
    }

    public List<Condition> buildConditions() {
        return build(conditions);
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<ConditionBuilder>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(Condition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public RevisionStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public RevisionStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public RevisionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public RevisionStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public RevisionStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public RevisionStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public RevisionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public A addToContainerStatuses(int index,ContainerStatuses item) {
        if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusesBuilder>();}
        ContainerStatusesBuilder builder = new ContainerStatusesBuilder(item);_visitables.get("containerStatuses").add(index >= 0 ? index : _visitables.get("containerStatuses").size(), builder);this.containerStatuses.add(index >= 0 ? index : containerStatuses.size(), builder); return (A)this;
    }

    public A setToContainerStatuses(int index,ContainerStatuses item) {
        if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusesBuilder>();}
        ContainerStatusesBuilder builder = new ContainerStatusesBuilder(item);
        if (index < 0 || index >= _visitables.get("containerStatuses").size()) { _visitables.get("containerStatuses").add(builder); } else { _visitables.get("containerStatuses").set(index, builder);}
        if (index < 0 || index >= containerStatuses.size()) { containerStatuses.add(builder); } else { containerStatuses.set(index, builder);}
         return (A)this;
    }

    public A addToContainerStatuses(ContainerStatuses... items) {
        if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusesBuilder>();}
        for (ContainerStatuses item : items) {ContainerStatusesBuilder builder = new ContainerStatusesBuilder(item);_visitables.get("containerStatuses").add(builder);this.containerStatuses.add(builder);} return (A)this;
    }

    public A addAllToContainerStatuses(Collection<ContainerStatuses> items) {
        if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusesBuilder>();}
        for (ContainerStatuses item : items) {ContainerStatusesBuilder builder = new ContainerStatusesBuilder(item);_visitables.get("containerStatuses").add(builder);this.containerStatuses.add(builder);} return (A)this;
    }

    public A removeFromContainerStatuses(ContainerStatuses... items) {
        for (ContainerStatuses item : items) {ContainerStatusesBuilder builder = new ContainerStatusesBuilder(item);_visitables.get("containerStatuses").remove(builder);if (this.containerStatuses != null) {this.containerStatuses.remove(builder);}} return (A)this;
    }

    public A removeAllFromContainerStatuses(Collection<ContainerStatuses> items) {
        for (ContainerStatuses item : items) {ContainerStatusesBuilder builder = new ContainerStatusesBuilder(item);_visitables.get("containerStatuses").remove(builder);if (this.containerStatuses != null) {this.containerStatuses.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusesBuilder> predicate) {
        if (containerStatuses == null) return (A) this;
        final Iterator<ContainerStatusesBuilder> each = containerStatuses.iterator();
        final List visitables = _visitables.get("containerStatuses");
        while (each.hasNext()) {
          ContainerStatusesBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildContainerStatuses instead.
 * @return The buildable object.
 */
@Deprecated public List<ContainerStatuses> getContainerStatuses() {
        return build(containerStatuses);
    }

    public List<ContainerStatuses> buildContainerStatuses() {
        return build(containerStatuses);
    }

    public ContainerStatuses buildContainerStatus(int index) {
        return this.containerStatuses.get(index).build();
    }

    public ContainerStatuses buildFirstContainerStatus() {
        return this.containerStatuses.get(0).build();
    }

    public ContainerStatuses buildLastContainerStatus() {
        return this.containerStatuses.get(containerStatuses.size() - 1).build();
    }

    public ContainerStatuses buildMatchingContainerStatus(Predicate<ContainerStatusesBuilder> predicate) {
        for (ContainerStatusesBuilder item: containerStatuses) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingContainerStatus(Predicate<ContainerStatusesBuilder> predicate) {
        for (ContainerStatusesBuilder item: containerStatuses) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withContainerStatuses(List<ContainerStatuses> containerStatuses) {
        if (this.containerStatuses != null) { _visitables.get("containerStatuses").removeAll(this.containerStatuses);}
        if (containerStatuses != null) {this.containerStatuses = new ArrayList<ContainerStatusesBuilder>(); for (ContainerStatuses item : containerStatuses){this.addToContainerStatuses(item);}} else { this.containerStatuses = null;} return (A) this;
    }

    public A withContainerStatuses(ContainerStatuses... containerStatuses) {
        if (this.containerStatuses != null) {this.containerStatuses.clear();}
        if (containerStatuses != null) {for (ContainerStatuses item :containerStatuses){ this.addToContainerStatuses(item);}} return (A) this;
    }

    public Boolean hasContainerStatuses() {
        return containerStatuses != null && !containerStatuses.isEmpty();
    }

    public A addNewContainerStatus(String imageDigest,String name) {
        return (A)addToContainerStatuses(new ContainerStatuses(imageDigest, name));
    }

    public RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatus() {
        return new ContainerStatusesNestedImpl();
    }

    public RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatuses item) {
        return new ContainerStatusesNestedImpl(-1, item);
    }

    public RevisionStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(int index,ContainerStatuses item) {
        return new ContainerStatusesNestedImpl(index, item);
    }

    public RevisionStatusFluent.ContainerStatusesNested<A> editContainerStatus(int index) {
        if (containerStatuses.size() <= index) throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
        return setNewContainerStatusLike(index, buildContainerStatus(index));
    }

    public RevisionStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus() {
        if (containerStatuses.size() == 0) throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
        return setNewContainerStatusLike(0, buildContainerStatus(0));
    }

    public RevisionStatusFluent.ContainerStatusesNested<A> editLastContainerStatus() {
        int index = containerStatuses.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
        return setNewContainerStatusLike(index, buildContainerStatus(index));
    }

    public RevisionStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusesBuilder> predicate) {
        int index = -1;
        for (int i=0;i<containerStatuses.size();i++) { 
        if (predicate.test(containerStatuses.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
        return setNewContainerStatusLike(index, buildContainerStatus(index));
    }

    public String getImageDigest() {
        return this.imageDigest;
    }

    public A withImageDigest(String imageDigest) {
        this.imageDigest=imageDigest; return (A) this;
    }

    public Boolean hasImageDigest() {
        return this.imageDigest != null;
    }

    public A withNewImageDigest(String arg1) {
        return (A)withImageDigest(new String(arg1));
    }

    public A withNewImageDigest(StringBuilder arg1) {
        return (A)withImageDigest(new String(arg1));
    }

    public A withNewImageDigest(StringBuffer arg1) {
        return (A)withImageDigest(new String(arg1));
    }

    public String getLogUrl() {
        return this.logUrl;
    }

    public A withLogUrl(String logUrl) {
        this.logUrl=logUrl; return (A) this;
    }

    public Boolean hasLogUrl() {
        return this.logUrl != null;
    }

    public A withNewLogUrl(String arg1) {
        return (A)withLogUrl(new String(arg1));
    }

    public A withNewLogUrl(StringBuilder arg1) {
        return (A)withLogUrl(new String(arg1));
    }

    public A withNewLogUrl(StringBuffer arg1) {
        return (A)withLogUrl(new String(arg1));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public A withServiceName(String serviceName) {
        this.serviceName=serviceName; return (A) this;
    }

    public Boolean hasServiceName() {
        return this.serviceName != null;
    }

    public A withNewServiceName(String arg1) {
        return (A)withServiceName(new String(arg1));
    }

    public A withNewServiceName(StringBuilder arg1) {
        return (A)withServiceName(new String(arg1));
    }

    public A withNewServiceName(StringBuffer arg1) {
        return (A)withServiceName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RevisionStatusFluentImpl that = (RevisionStatusFluentImpl) o;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (containerStatuses != null ? !containerStatuses.equals(that.containerStatuses) :that.containerStatuses != null) return false;
        if (imageDigest != null ? !imageDigest.equals(that.imageDigest) :that.imageDigest != null) return false;
        if (logUrl != null ? !logUrl.equals(that.logUrl) :that.logUrl != null) return false;
        if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
        if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(annotations,  conditions,  containerStatuses,  imageDigest,  logUrl,  observedGeneration,  serviceName,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends ConditionFluentImpl<RevisionStatusFluent.ConditionsNested<N>> implements RevisionStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index,Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ConditionBuilder(this);
        }

        public N and() {
             return (N) RevisionStatusFluentImpl.this.setToConditions(index,builder.build());
        }

        public N endCondition() {
             return and();
        }
    }


    public class ContainerStatusesNestedImpl<N> extends ContainerStatusesFluentImpl<RevisionStatusFluent.ContainerStatusesNested<N>> implements RevisionStatusFluent.ContainerStatusesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerStatusesBuilder builder;
        private final int index;

        ContainerStatusesNestedImpl(int index,ContainerStatuses item) {
            this.index = index;
            this.builder = new ContainerStatusesBuilder(this, item);
        }

        ContainerStatusesNestedImpl() {
            this.index = -1;
            this.builder = new ContainerStatusesBuilder(this);
        }

        public N and() {
             return (N) RevisionStatusFluentImpl.this.setToContainerStatuses(index,builder.build());
        }

        public N endContainerStatus() {
             return and();
        }
    }


}
