package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;
import java.lang.Boolean;

public class CouchDbSourceSpecFluentImpl<A extends CouchDbSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CouchDbSourceSpecFluent<A> {

    private ObjectReference credentials;
    private String database;
    private String feed;
    private String serviceAccountName;
    private DestinationBuilder sink;

    public CouchDbSourceSpecFluentImpl() { 
    }


    public CouchDbSourceSpecFluentImpl(CouchDbSourceSpec instance) { 
        this.withCredentials(instance.getCredentials()); 
        this.withDatabase(instance.getDatabase()); 
        this.withFeed(instance.getFeed()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSink(instance.getSink()); 
    }


    public ObjectReference getCredentials() {
        return this.credentials;
    }

    public A withCredentials(ObjectReference credentials) {
        this.credentials=credentials; return (A) this;
    }

    public Boolean hasCredentials() {
        return this.credentials != null;
    }

    public String getDatabase() {
        return this.database;
    }

    public A withDatabase(String database) {
        this.database=database; return (A) this;
    }

    public Boolean hasDatabase() {
        return this.database != null;
    }

    public A withNewDatabase(String arg1) {
        return (A)withDatabase(new String(arg1));
    }

    public A withNewDatabase(StringBuilder arg1) {
        return (A)withDatabase(new String(arg1));
    }

    public A withNewDatabase(StringBuffer arg1) {
        return (A)withDatabase(new String(arg1));
    }

    public String getFeed() {
        return this.feed;
    }

    public A withFeed(String feed) {
        this.feed=feed; return (A) this;
    }

    public Boolean hasFeed() {
        return this.feed != null;
    }

    public A withNewFeed(String arg1) {
        return (A)withFeed(new String(arg1));
    }

    public A withNewFeed(StringBuilder arg1) {
        return (A)withFeed(new String(arg1));
    }

    public A withNewFeed(StringBuffer arg1) {
        return (A)withFeed(new String(arg1));
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@Deprecated public Destination getSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public Destination buildSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public A withSink(Destination sink) {
        _visitables.get("sink").remove(this.sink);
        if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} return (A) this;
    }

    public Boolean hasSink() {
        return this.sink != null;
    }

    public CouchDbSourceSpecFluent.SinkNested<A> withNewSink() {
        return new SinkNestedImpl();
    }

    public CouchDbSourceSpecFluent.SinkNested<A> withNewSinkLike(Destination item) {
        return new SinkNestedImpl(item);
    }

    public CouchDbSourceSpecFluent.SinkNested<A> editSink() {
        return withNewSinkLike(getSink());
    }

    public CouchDbSourceSpecFluent.SinkNested<A> editOrNewSink() {
        return withNewSinkLike(getSink() != null ? getSink(): new DestinationBuilder().build());
    }

    public CouchDbSourceSpecFluent.SinkNested<A> editOrNewSinkLike(Destination item) {
        return withNewSinkLike(getSink() != null ? getSink(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CouchDbSourceSpecFluentImpl that = (CouchDbSourceSpecFluentImpl) o;
        if (credentials != null ? !credentials.equals(that.credentials) :that.credentials != null) return false;
        if (database != null ? !database.equals(that.database) :that.database != null) return false;
        if (feed != null ? !feed.equals(that.feed) :that.feed != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        if (sink != null ? !sink.equals(that.sink) :that.sink != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(credentials,  database,  feed,  serviceAccountName,  sink,  super.hashCode());
    }

    public class SinkNestedImpl<N> extends DestinationFluentImpl<CouchDbSourceSpecFluent.SinkNested<N>> implements CouchDbSourceSpecFluent.SinkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DestinationBuilder builder;

        SinkNestedImpl(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        SinkNestedImpl() {
            this.builder = new DestinationBuilder(this);
        }

        public N and() {
             return (N) CouchDbSourceSpecFluentImpl.this.withSink(builder.build());
        }

        public N endSink() {
             return and();
        }
    }


}
